/*
 * Decompiled with CFR 0.152.
 */
package mecosim.plugins.processes;

import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import javax.swing.JOptionPane;

public class DesktopRunner {
    public static void main(String[] args) {
    }

    public static void open(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                block7: {
                    if (Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                        File f = null;
                        String title = "";
                        String message = "";
                        try {
                            f = new File(args[0]);
                            if (f != null && f.exists() && f.isFile()) {
                                Desktop.getDesktop().open(f);
                                break block7;
                            }
                            title = "File not found!";
                            message = "The file " + f.getAbsolutePath() + " does not exist!\n";
                            JOptionPane.showMessageDialog(null, message, title, 0);
                        }
                        catch (IOException e) {
                            message = "The file " + f.getAbsolutePath() + " has not associated a default program to be opened\n" + "However, a copy of the file with extension .txt will be created," + " and the file will be opened in your corresponding text editor.";
                            title = "Default program not available in your OS";
                            JOptionPane.showMessageDialog(null, message, title, 2);
                            String name = f.getAbsolutePath();
                            String newName = String.valueOf(name.substring(0, name.lastIndexOf("."))) + ".txt";
                            Path source = Paths.get(name, new String[0]);
                            Path newdir = Paths.get(newName, new String[0]);
                            try {
                                Files.copy(source, newdir, StandardCopyOption.REPLACE_EXISTING);
                                File newFile = new File(newName);
                                Desktop.getDesktop().open(newFile);
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                    } else {
                        String title = "Operation not supported";
                        String message = "Sorry, but the requested operation is not available in your system";
                        JOptionPane.showMessageDialog(null, message, title, 0);
                    }
                }
            }
        });
    }

    public static void email(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                block10: {
                    if (args != null && args.length > 0) {
                        String mailTo = args[0];
                        URI uriMailTo = null;
                        try {
                            if (Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
                                if (mailTo.length() > 0) {
                                    uriMailTo = new URI("mailto", mailTo, null);
                                    Desktop.getDesktop().mail(uriMailTo);
                                } else {
                                    Desktop.getDesktop().mail();
                                }
                                break block10;
                            }
                            String title = "Operation not supported";
                            String message = "Sorry, but the requested operation is not available in your system";
                            JOptionPane.showMessageDialog(null, message, title, 0);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                        catch (URISyntaxException use) {
                            use.printStackTrace();
                        }
                    } else {
                        try {
                            Desktop.getDesktop().mail();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public static void browse(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    if (args != null && args.length > 0) {
                        URI uri = null;
                        try {
                            uri = new URI(args[0]);
                            Desktop.getDesktop().browse(uri);
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                        }
                        catch (URISyntaxException use) {
                            use.printStackTrace();
                        }
                    }
                } else {
                    String title = "Operation not supported";
                    String message = "Sorry, but the requested operation is not available in your system";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                }
            }
        });
    }
}

