/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.LinkedHashSet;
import java.util.Set;

public class PluggableGraphMouse
implements VisualizationViewer.GraphMouse {
    MouseListener[] mouseListeners;
    MouseMotionListener[] mouseMotionListeners;
    MouseWheelListener[] mouseWheelListeners;
    Set<GraphMousePlugin> mousePluginList = new LinkedHashSet<GraphMousePlugin>();
    Set<MouseMotionListener> mouseMotionPluginList = new LinkedHashSet<MouseMotionListener>();
    Set<MouseWheelListener> mouseWheelPluginList = new LinkedHashSet<MouseWheelListener>();

    public void add(GraphMousePlugin plugin) {
        if (plugin instanceof MouseListener) {
            this.mousePluginList.add(plugin);
            this.mouseListeners = null;
        }
        if (plugin instanceof MouseMotionListener) {
            this.mouseMotionPluginList.add((MouseMotionListener)((Object)plugin));
            this.mouseMotionListeners = null;
        }
        if (plugin instanceof MouseWheelListener) {
            this.mouseWheelPluginList.add((MouseWheelListener)((Object)plugin));
            this.mouseWheelListeners = null;
        }
    }

    public void remove(GraphMousePlugin plugin) {
        boolean wasThere;
        if (plugin instanceof MouseListener && (wasThere = this.mousePluginList.remove(plugin))) {
            this.mouseListeners = null;
        }
        if (plugin instanceof MouseMotionListener && (wasThere = this.mouseMotionPluginList.remove(plugin))) {
            this.mouseMotionListeners = null;
        }
        if (plugin instanceof MouseWheelListener && (wasThere = this.mouseWheelPluginList.remove(plugin))) {
            this.mouseWheelListeners = null;
        }
    }

    private void checkMouseListeners() {
        if (this.mouseListeners == null) {
            this.mouseListeners = this.mousePluginList.toArray(new MouseListener[this.mousePluginList.size()]);
        }
    }

    private void checkMouseMotionListeners() {
        if (this.mouseMotionListeners == null) {
            this.mouseMotionListeners = this.mouseMotionPluginList.toArray(new MouseMotionListener[this.mouseMotionPluginList.size()]);
        }
    }

    private void checkMouseWheelListeners() {
        if (this.mouseWheelListeners == null) {
            this.mouseWheelListeners = this.mouseWheelPluginList.toArray(new MouseWheelListener[this.mouseWheelPluginList.size()]);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.checkMouseListeners();
        int i = 0;
        while (i < this.mouseListeners.length) {
            this.mouseListeners[i].mouseClicked(e);
            if (e.isConsumed()) break;
            ++i;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.checkMouseListeners();
        int i = 0;
        while (i < this.mouseListeners.length) {
            this.mouseListeners[i].mousePressed(e);
            if (e.isConsumed()) break;
            ++i;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkMouseListeners();
        int i = 0;
        while (i < this.mouseListeners.length) {
            this.mouseListeners[i].mouseReleased(e);
            if (e.isConsumed()) break;
            ++i;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.checkMouseListeners();
        int i = 0;
        while (i < this.mouseListeners.length) {
            this.mouseListeners[i].mouseEntered(e);
            if (e.isConsumed()) break;
            ++i;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.checkMouseListeners();
        int i = 0;
        while (i < this.mouseListeners.length) {
            this.mouseListeners[i].mouseExited(e);
            if (e.isConsumed()) break;
            ++i;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.checkMouseMotionListeners();
        int i = 0;
        while (i < this.mouseMotionListeners.length) {
            this.mouseMotionListeners[i].mouseDragged(e);
            if (e.isConsumed()) break;
            ++i;
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.checkMouseMotionListeners();
        int i = 0;
        while (i < this.mouseMotionListeners.length) {
            this.mouseMotionListeners[i].mouseMoved(e);
            if (e.isConsumed()) break;
            ++i;
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.checkMouseWheelListeners();
        int i = 0;
        while (i < this.mouseWheelListeners.length) {
            this.mouseWheelListeners[i].mouseWheelMoved(e);
            if (e.isConsumed()) break;
            ++i;
        }
    }
}

