/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.visualization.FourPassImageShaper;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class PivotingImageShaper {
    static int sample = 1;
    static int firstx = 0;

    public static Shape getShape(String fileName) {
        return PivotingImageShaper.getShape(fileName, Integer.MAX_VALUE);
    }

    public static Shape getShape(String fileName, int max) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(FourPassImageShaper.class.getResource(fileName));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return PivotingImageShaper.getShape(image, max);
    }

    public static Shape getShape(Image image) {
        return PivotingImageShaper.getShape(image, Integer.MAX_VALUE);
    }

    public static Shape getShape(Image image, int max) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bi.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return PivotingImageShaper.getShape(bi, max);
    }

    public static Shape getShape(BufferedImage image, int max) {
        float width = image.getWidth();
        float height = image.getHeight();
        if (width > (float)max || height > (float)max) {
            BufferedImage smaller = new BufferedImage(max, max, 2);
            Graphics2D g = smaller.createGraphics();
            AffineTransform at = AffineTransform.getScaleInstance((float)max / width, (float)max / height);
            AffineTransform back = AffineTransform.getScaleInstance(width / (float)max, height / (float)max);
            Graphics2D g2 = g;
            g2.drawImage(image, at, null);
            g2.dispose();
            return back.createTransformedShape(PivotingImageShaper.getShape(smaller));
        }
        return PivotingImageShaper.getShape(image);
    }

    public static Shape getShape(BufferedImage image) {
        firstx = 0;
        return PivotingImageShaper.leftEdge(image, new GeneralPath());
    }

    private static Point2D detectLine(Point2D p1, Point2D p2, Point2D p, Line2D line, GeneralPath path) {
        if (p2 == null) {
            p2 = p;
            line.setLine(p1, p2);
        } else if (line.ptLineDistSq(p) < 1.0) {
            p2.setLocation(p);
        } else {
            p1.setLocation(p2);
            p2.setLocation(p);
            line.setLine(p1, p2);
            path.lineTo((float)p1.getX(), (float)p1.getY());
        }
        return p2;
    }

    private static Shape leftEdge(BufferedImage image, GeneralPath path) {
        int lastj = 0;
        Point2D.Float p1 = null;
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        int i = 0;
        while (i < image.getHeight()) {
            boolean aPointExistsOnThisLine = false;
            int j = 0;
            while (j < image.getWidth()) {
                if ((image.getRGB(j, i) & 0xFF000000) != 0) {
                    Point2D.Float p = new Point2D.Float(j, i);
                    aPointExistsOnThisLine = true;
                    if (path.getCurrentPoint() != null) {
                        p2 = PivotingImageShaper.detectLine(p1, p2, p, line, path);
                    } else {
                        path.moveTo(j, i);
                        firstx = j;
                        p1 = p;
                    }
                    lastj = j;
                    break;
                }
                j += sample;
            }
            if (!aPointExistsOnThisLine) break;
            i += sample;
        }
        return PivotingImageShaper.bottomEdge(image, path, lastj);
    }

    private static Shape bottomEdge(BufferedImage image, GeneralPath path, int start) {
        int lastj = 0;
        Point2D p1 = path.getCurrentPoint();
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        int i = start;
        while (i < image.getWidth()) {
            boolean aPointExistsOnThisLine = false;
            int j = image.getHeight() - 1;
            while (j >= 0) {
                if ((image.getRGB(i, j) & 0xFF000000) != 0) {
                    Point2D.Float p = new Point2D.Float(i, j);
                    aPointExistsOnThisLine = true;
                    p2 = PivotingImageShaper.detectLine(p1, p2, p, line, path);
                    lastj = j;
                    break;
                }
                j -= sample;
            }
            if (!aPointExistsOnThisLine) break;
            i += sample;
        }
        return PivotingImageShaper.rightEdge(image, path, lastj);
    }

    private static Shape rightEdge(BufferedImage image, GeneralPath path, int start) {
        int lastj = 0;
        Point2D p1 = path.getCurrentPoint();
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        int i = start;
        while (i >= 0) {
            boolean aPointExistsOnThisLine = false;
            int j = image.getWidth() - 1;
            while (j >= 0) {
                if ((image.getRGB(j, i) & 0xFF000000) != 0) {
                    Point2D.Float p = new Point2D.Float(j, i);
                    aPointExistsOnThisLine = true;
                    p2 = PivotingImageShaper.detectLine(p1, p2, p, line, path);
                    lastj = j;
                    break;
                }
                j -= sample;
            }
            if (!aPointExistsOnThisLine) break;
            i -= sample;
        }
        return PivotingImageShaper.topEdge(image, path, lastj);
    }

    private static Shape topEdge(BufferedImage image, GeneralPath path, int start) {
        Point2D p1 = path.getCurrentPoint();
        Point2D p2 = null;
        Line2D.Float line = new Line2D.Float();
        int i = start;
        while (i >= firstx) {
            boolean aPointExistsOnThisLine = false;
            int j = 0;
            while (j < image.getHeight()) {
                if ((image.getRGB(i, j) & 0xFF000000) != 0) {
                    Point2D.Float p = new Point2D.Float(i, j);
                    aPointExistsOnThisLine = true;
                    p2 = PivotingImageShaper.detectLine(p1, p2, p, line, path);
                    break;
                }
                j += sample;
            }
            if (!aPointExistsOnThisLine) break;
            i -= sample;
        }
        path.closePath();
        return path;
    }
}

