/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.ExceptionConverter;
import edu.uci.ics.jung.io.graphml.parser.ElementParser;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class UnknownElementParser
implements ElementParser {
    @Override
    public Object parse(XMLEventReader xmlEventReader, StartElement start) throws GraphIOException {
        try {
            Stack<String> skippedElements = new Stack<String>();
            skippedElements.add(start.getName().getLocalPart());
            while (xmlEventReader.hasNext()) {
                String name;
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    name = event.asStartElement().getName().getLocalPart();
                    skippedElements.push(name);
                }
                if (!event.isEndElement()) continue;
                name = event.asEndElement().getName().getLocalPart();
                if (skippedElements.size() == 0 || !((String)skippedElements.peek()).equals(name)) {
                    throw new GraphIOException("Failed parsing GraphML document - startTag/endTag mismatch");
                }
                skippedElements.pop();
                if (skippedElements.isEmpty()) break;
            }
            return null;
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
            return null;
        }
    }
}

