/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.HyperEdgeMetadata;
import edu.uci.ics.jung.io.graphml.KeyMap;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import edu.uci.ics.jung.io.graphml.parser.DataElementParser;
import edu.uci.ics.jung.io.graphml.parser.EdgeElementParser;
import edu.uci.ics.jung.io.graphml.parser.ElementParser;
import edu.uci.ics.jung.io.graphml.parser.EndpointElementParser;
import edu.uci.ics.jung.io.graphml.parser.GraphElementParser;
import edu.uci.ics.jung.io.graphml.parser.HyperEdgeElementParser;
import edu.uci.ics.jung.io.graphml.parser.KeyElementParser;
import edu.uci.ics.jung.io.graphml.parser.NodeElementParser;
import edu.uci.ics.jung.io.graphml.parser.ParserContext;
import edu.uci.ics.jung.io.graphml.parser.PortElementParser;
import edu.uci.ics.jung.io.graphml.parser.StringElementParser;
import edu.uci.ics.jung.io.graphml.parser.UnknownElementParser;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Transformer;

public class ElementParserRegistry<G extends Hypergraph<V, E>, V, E> {
    private final Map<String, ElementParser> parserMap = new HashMap<String, ElementParser>();
    private final ElementParser unknownElementParser = new UnknownElementParser();

    public ElementParserRegistry(KeyMap keyMap, Transformer<GraphMetadata, G> graphTransformer, Transformer<NodeMetadata, V> vertexTransformer, Transformer<EdgeMetadata, E> edgeTransformer, Transformer<HyperEdgeMetadata, E> hyperEdgeTransformer) {
        ParserContext<G, V, E> context = new ParserContext<G, V, E>(this, keyMap, graphTransformer, vertexTransformer, edgeTransformer, hyperEdgeTransformer);
        this.parserMap.put("default", new StringElementParser<G, V, E>(context));
        this.parserMap.put("desc", new StringElementParser<G, V, E>(context));
        this.parserMap.put("key", new KeyElementParser<G, V, E>(context));
        this.parserMap.put("data", new DataElementParser<G, V, E>(context));
        this.parserMap.put("port", new PortElementParser<G, V, E>(context));
        this.parserMap.put("node", new NodeElementParser<G, V, E>(context));
        this.parserMap.put("graph", new GraphElementParser<G, V, E>(context));
        this.parserMap.put("endpoint", new EndpointElementParser<G, V, E>(context));
        this.parserMap.put("edge", new EdgeElementParser<G, V, E>(context));
        this.parserMap.put("hyperedge", new HyperEdgeElementParser<G, V, E>(context));
    }

    public ElementParser getUnknownElementParser() {
        return this.unknownElementParser;
    }

    public ElementParser getParser(String localName) {
        ElementParser parser = this.parserMap.get(localName);
        if (parser == null) {
            parser = this.unknownElementParser;
        }
        return parser;
    }
}

