/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import edu.uci.ics.jung.algorithms.matrix.GraphMatrixOperations;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.io.GraphFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections15.Factory;

public class MatrixFile<V, E>
implements GraphFile<V, E> {
    private Map<E, Number> mWeightKey;
    Factory<? extends Graph<V, E>> graphFactory;
    Factory<V> vertexFactory;
    Factory<E> edgeFactory;

    public MatrixFile(Map<E, Number> weightKey, Factory<? extends Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory) {
        this.mWeightKey = weightKey;
        this.graphFactory = graphFactory;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
    }

    public Graph<V, E> load(BufferedReader reader) throws IOException {
        Graph<V, E> graph = null;
        DoubleMatrix2D matrix = this.createMatrixFromFile(reader);
        graph = GraphMatrixOperations.matrixToGraph(matrix, this.graphFactory, this.vertexFactory, this.edgeFactory);
        return graph;
    }

    private DoubleMatrix2D createMatrixFromFile(BufferedReader reader) throws IOException {
        ArrayList rows = new ArrayList();
        String currentLine = null;
        while ((currentLine = reader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(currentLine);
            if (tokenizer.countTokens() == 0) break;
            ArrayList<Double> currentRow = new ArrayList<Double>();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                currentRow.add(Double.parseDouble(token));
            }
            rows.add(currentRow);
        }
        int size = rows.size();
        SparseDoubleMatrix2D matrix = new SparseDoubleMatrix2D(size, size);
        int i = 0;
        while (i < size) {
            List currentRow = (List)rows.get(i);
            if (currentRow.size() != size) {
                throw new IllegalArgumentException("Matrix must have the same number of rows as columns");
            }
            int j = 0;
            while (j < size) {
                double currentVal = (Double)currentRow.get(j);
                if (currentVal != 0.0) {
                    ((DoubleMatrix2D)matrix).setQuick(i, j, currentVal);
                }
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    @Override
    public Graph<V, E> load(String filename) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            Graph<V, E> graph = this.load(reader);
            reader.close();
            return graph;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error in loading file " + filename, ioe);
        }
    }

    @Override
    public void save(Graph<V, E> graph, String filename) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            SparseDoubleMatrix2D matrix = GraphMatrixOperations.graphToSparseMatrix(graph, this.mWeightKey);
            int i = 0;
            while (i < matrix.rows()) {
                int j = 0;
                while (j < matrix.columns()) {
                    writer.write(String.format("%4.2f ", ((DoubleMatrix2D)matrix).getQuick(i, j)));
                    ++j;
                }
                writer.write("\n");
                ++i;
            }
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving file: " + filename, e);
        }
    }
}

