/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.transformation;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.KPartiteGraph;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Predicate;

public class FoldingTransformer<V, E> {
    public static <V, E> Graph<V, E> foldKPartiteGraph(KPartiteGraph<V, E> g, Predicate<V> p, Factory<Graph<V, E>> graph_factory, Factory<E> edge_factory) {
        Graph<V, E> newGraph = graph_factory.create();
        Collection<V> vertices = g.getVertices(p);
        for (V v : vertices) {
            newGraph.addVertex(v);
            for (V s : g.getSuccessors(v)) {
                for (V t : g.getSuccessors(s)) {
                    if (!vertices.contains(t) || t.equals(v)) continue;
                    newGraph.addVertex(t);
                    newGraph.addEdge(edge_factory.create(), v, t);
                }
            }
        }
        return newGraph;
    }

    public static <V, E> Graph<V, Collection<V>> foldKPartiteGraph(KPartiteGraph<V, E> g, Predicate<V> p, Factory<Graph<V, Collection<V>>> graph_factory) {
        Graph<V, Collection<V>> newGraph = graph_factory.create();
        Collection<V> vertices = g.getVertices(p);
        for (V v : vertices) {
            newGraph.addVertex(v);
            for (V s : g.getSuccessors(v)) {
                for (V t : g.getSuccessors(s)) {
                    if (!vertices.contains(t) || t.equals(v)) continue;
                    newGraph.addVertex(t);
                    ArrayList<V> v_coll = (ArrayList<V>)newGraph.findEdge(v, t);
                    if (v_coll == null) {
                        v_coll = new ArrayList<V>();
                        newGraph.addEdge(v_coll, v, t);
                    }
                    v_coll.add(s);
                }
            }
        }
        return newGraph;
    }

    public static <V, E> Graph<V, Collection<E>> foldHypergraphEdges(Hypergraph<V, E> h, Factory<Graph<V, Collection<E>>> graph_factory) {
        Graph<V, Collection<E>> target = graph_factory.create();
        for (V v : h.getVertices()) {
            target.addVertex(v);
        }
        for (Object e : h.getEdges()) {
            ArrayList<V> incident = new ArrayList<V>(h.getIncidentVertices(e));
            FoldingTransformer.populateTarget(target, e, incident);
        }
        return target;
    }

    public static <V, E> Graph<V, E> foldHypergraphEdges(Hypergraph<V, E> h, Factory<Graph<V, E>> graph_factory, Factory<E> edge_factory) {
        Graph<V, E> target = graph_factory.create();
        for (V v : h.getVertices()) {
            target.addVertex(v);
        }
        for (Object e : h.getEdges()) {
            ArrayList<V> incident = new ArrayList<V>(h.getIncidentVertices(e));
            int i = 0;
            while (i < incident.size()) {
                int j = i + 1;
                while (j < incident.size()) {
                    target.addEdge(edge_factory.create(), incident.get(i), incident.get(j));
                    ++j;
                }
                ++i;
            }
        }
        return target;
    }

    public static <V, E, F> Graph<E, F> foldHypergraphVertices(Hypergraph<V, E> h, Factory<Graph<E, F>> graph_factory, Factory<F> edge_factory) {
        Graph<F, F> target = graph_factory.create();
        for (E e : h.getEdges()) {
            target.addVertex(e);
        }
        for (Object v : h.getVertices()) {
            ArrayList<E> incident = new ArrayList<E>(h.getIncidentEdges(v));
            int i = 0;
            while (i < incident.size()) {
                int j = i + 1;
                while (j < incident.size()) {
                    target.addEdge(edge_factory.create(), incident.get(i), incident.get(j));
                    ++j;
                }
                ++i;
            }
        }
        return target;
    }

    public Graph<E, Collection<V>> foldHypergraphVertices(Hypergraph<V, E> h, Factory<Graph<E, Collection<V>>> graph_factory) {
        Graph<E, Collection<E>> target = graph_factory.create();
        for (E e : h.getEdges()) {
            target.addVertex(e);
        }
        for (Object v : h.getVertices()) {
            ArrayList<E> incident = new ArrayList<E>(h.getIncidentEdges(v));
            FoldingTransformer.populateTarget(target, v, incident);
        }
        return target;
    }

    private static <S, T> void populateTarget(Graph<S, Collection<T>> target, T e, ArrayList<S> incident) {
        int i = 0;
        while (i < incident.size()) {
            S v1 = incident.get(i);
            int j = i + 1;
            while (j < incident.size()) {
                S v2 = incident.get(j);
                ArrayList<T> e_coll = (ArrayList<T>)target.findEdge(v1, v2);
                if (e_coll == null) {
                    e_coll = new ArrayList<T>();
                    target.addEdge(e_coll, v1, v2);
                }
                e_coll.add(e);
                ++j;
            }
            ++i;
        }
    }
}

