/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.metrics;

import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Metrics {
    public static <V, E> Map<V, Double> clusteringCoefficients(Graph<V, E> graph) {
        HashMap coefficients = new HashMap();
        for (Object v : graph.getVertices()) {
            int n = graph.getNeighborCount(v);
            if (n < 2) {
                coefficients.put(v, new Double(0.0));
                continue;
            }
            ArrayList neighbors = new ArrayList(graph.getNeighbors(v));
            double edge_count = 0.0;
            int i = 0;
            while (i < n) {
                Object w = neighbors.get(i);
                int j = i + 1;
                while (j < n) {
                    Object x = neighbors.get(j);
                    edge_count += (double)(graph.isNeighbor(w, x) ? 1 : 0);
                    ++j;
                }
                ++i;
            }
            double possible_edges = (double)(n * (n - 1)) / 2.0;
            coefficients.put(v, new Double(edge_count / possible_edges));
        }
        return coefficients;
    }
}

