/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.RandomWalkSTBetweenness;
import edu.uci.ics.jung.graph.UndirectedGraph;

public class RandomWalkBetweenness<V, E>
extends RandomWalkSTBetweenness<V, E> {
    public static final String CENTRALITY = "centrality.RandomWalkBetweennessCentrality";

    public RandomWalkBetweenness(UndirectedGraph<V, E> g) {
        super(g, null, null);
    }

    @Override
    protected void computeBetweenness() {
        this.setUp();
        int numVertices = this.getGraph().getVertexCount();
        double normalizingConstant = (double)(numVertices * (numVertices - 1)) / 2.0;
        for (Object ithVertex : this.getGraph().getVertices()) {
            double ithBetweenness = 0.0;
            int t = 0;
            while (t < numVertices) {
                int s = 0;
                while (s < t) {
                    Object sthVertex = this.getIndexer().getKey(s);
                    Object tthVertex = this.getIndexer().getKey(t);
                    ithBetweenness += this.computeSTBetweenness(ithVertex, sthVertex, tthVertex);
                    ++s;
                }
                ++t;
            }
            this.setVertexRankScore(ithVertex, ithBetweenness / normalizingConstant);
        }
    }

    @Override
    public String getRankScoreKey() {
        return CENTRALITY;
    }

    protected double evaluateIteration() {
        this.computeBetweenness();
        return 0.0;
    }
}

