/* 
 * pLinguaCore: A JAVA library for Membrane Computing
 *              http://www.p-lingua.org
 *
 * Copyright (C) 2009  Research Group on Natural Computing
 *                     http://www.gcn.us.es
 *                      
 * This file is part of pLinguaCore.
 *
 * pLinguaCore is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * pLinguaCore is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with pLinguaCore.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.gcn.plinguacore.parser.output.binary;


import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.gcn.plinguacore.simulator.cellLike.probabilistic.ProbabilisticPsystemFactory;
import org.gcn.plinguacore.util.psystem.ActivationSets;
import org.gcn.plinguacore.util.psystem.cellLike.CellLikePsystem;
import org.gcn.plinguacore.util.psystem.rule.IRule;


/**
 * This class writes a probabilistic P system in a binary file (under development)
 * 
 *  @author Research Group on Natural Computing (http://www.gcn.us.es)
 * 
 */
class ProbabilisticBinaryOutputParser extends AbstractBinaryOutputParser {

	@Override
	protected void writeHead() throws IOException {
		writeHead(PROBABILISTIC_ID);
	}

	@Override
	protected void writeRules() throws IOException {
		// TODO Auto-generated method stub
		Map<ActivationSets,List<IRule>> map=ProbabilisticPsystemFactory.getRulesByActivationSet((CellLikePsystem)getPsystem());
		/* Nº de bloques */
		getStream().writeInt(map.size());
		/* Nº total de reglas */
		getStream().writeInt(getPsystem().getRules().size());
		Iterator <ActivationSets>it=map.keySet().iterator();
		
		while(it.hasNext())
		{
			ActivationSets lhr = it.next();
			List<IRule>rules = map.get(lhr);
			/* Nº de reglas en el bloque */
			getStream().writeByte(rules.size());
			
			
		}
	
	
	}

	

}
