package org.gcn.plinguacore.parser.input.plingua;

import org.gcn.plinguacore.util.psystem.Psystem;
import org.gcn.plinguacore.util.psystem.rule.HandRule;
import org.gcn.plinguacore.util.psystem.rule.IRule;
import org.gcn.plinguacore.util.psystem.rule.LeftHandRule;
import org.gcn.plinguacore.util.psystem.rule.RightHandRule;

public class RuleChecker {
	public static boolean sameLabel(RightHandRule rightHandRule, LeftHandRule leftHandRule){
		return leftHandRule.getOuterRuleMembrane().getLabel().equals(rightHandRule.getOuterRuleMembrane().getLabel());
	}
	
	public static boolean isDivisionOrRelabellingRule(LeftHandRule leftHandRule, RightHandRule rightHandRule){
		return leftHandRule.getOuterRuleMembrane().getMultiSet()==null||leftHandRule.getOuterRuleMembrane().getMultiSet().isEmpty();
	}
	
	public static boolean matchModelID(Psystem psystem, String modelID){
		return psystem.getAbstractPsystemFactory().getModelName()
		     .equals(modelID);
	}
}
