/* 
 * pLinguaCore: A JAVA library for Membrane Computing
 *              http://www.p-lingua.org
 *
 * Copyright (C) 2009  Research Group on Natural Computing
 *                     http://www.gcn.us.es
 *                      
 * This file is part of pLinguaCore.
 *
 * pLinguaCore is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * pLinguaCore is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with pLinguaCore.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.gcn.plinguacore.simulator.kernel;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

import org.gcn.plinguacore.parser.output.promela.BasePromelaOutputParser;
import org.gcn.plinguacore.parser.output.promela.PromelaOutputParserFactory;
import org.gcn.plinguacore.simulator.AbstractSelectionExecutionSimulator;
import org.gcn.plinguacore.simulator.IExternalSimulator;
import org.gcn.plinguacore.util.Triple;
import org.gcn.plinguacore.util.psystem.Configuration;
import org.gcn.plinguacore.util.psystem.Psystem;
import org.gcn.plinguacore.util.psystem.kernel.membrane.SimpleKernelLikeMembraneStructure;
import org.gcn.plinguacore.util.psystem.membrane.ChangeableMembrane;
import org.gcn.plinguacore.util.psystem.membrane.MembraneStructure;
import org.gcn.plinguacore.util.psystem.rule.IKernelRule;
import org.gcn.plinguacore.util.psystem.rule.IRule;
import org.gcn.plinguacore.util.psystem.rule.RulesSet;
import org.gcn.plinguacore.util.psystem.rule.kernel.DivisionKernelLikeRule;
import org.gcn.plinguacore.util.psystem.rule.kernel.EvolutionCommunicationKernelLikeRule;
import org.gcn.plinguacore.util.psystem.rule.kernel.InputOutputKernelLikeRule;
import org.gcn.plinguacore.util.psystem.rule.kernel.SimpleKernelLikePsystem;
import org.gcn.plinguacore.util.psystem.tissueLike.membrane.TissueLikeMembrane;
import org.gcn.plinguacore.util.psystem.tissueLike.membrane.TissueLikeMembraneStructure;

import java.util.List;

public class PromelaKernelSimulator extends AbstractSelectionExecutionSimulator implements IExternalSimulator {

	/**
	 * 
	 */
	private static final int DIVISION_STAGE=2;
	private static final int INPUT_OUTPUT_STAGE=1;
	private static final int EVOLUTION_AND_COMMUNICATION_STAGE=0;
	private static final long serialVersionUID = -1556761252509150318L;
	private static final int STATE_SELECT_DIVISION=10;
	private static final int STATE_SELECT_COMMUNICATION=20;
	private static final int STATE_SELECT_INPUT_OUTPUT=30;
	private int steps = 0;
	private int state;
	protected SimpleKernelLikeMembraneStructure structure;
	private Map<Integer,Triple<DivisionKernelLikeRule,ChangeableMembrane,Long>>membranesToDivide;
	private List<Triple<EvolutionCommunicationKernelLikeRule, ChangeableMembrane, Long>> evolutionRules;
	private List<Triple<InputOutputKernelLikeRule, ChangeableMembrane, Long>> inputOutputRules;
	private boolean launched = false;
	
	public PromelaKernelSimulator(Psystem psystem) {
		super(psystem);
		evolutionRules = new LinkedList<Triple<EvolutionCommunicationKernelLikeRule, ChangeableMembrane, Long>>();
		membranesToDivide = new HashMap<Integer,Triple<DivisionKernelLikeRule,ChangeableMembrane,Long>>();
		inputOutputRules = new LinkedList<Triple<InputOutputKernelLikeRule, ChangeableMembrane, Long>>();
	}

	private void generatePromelaFile() {
		// TODO Auto-generated method stub
		String dir = "userfiles/";
		String promelaFilename = "promela-file.pml";
		generatePromelaFile(new String[]{dir+promelaFilename});
		
	}

	@Override
	public void setSteps(int n) {
		this.steps = n;
	}

	public void generatePromelaFile(String[] args) {
		Psystem ps = getPsystem();
		if (ps instanceof SimpleKernelLikePsystem){			
			FileWriter fw = null;
			File pf = null;
			try {
				String path = "userfiles/promela-file.pml";		
				if (args != null && args.length > 0){
					String searchPath = args[0];
					if (searchPath != null && !searchPath.equals(""))
						path = searchPath;
				}
				pf = new File(path);
				fw = new FileWriter(pf);
				
				BasePromelaOutputParser op = new PromelaOutputParserFactory();
				op.setSimulationStepCount(steps);
				op.parse(ps, fw);
				
				fw.close();
				//JOptionPane.showMessageDialog(null, "Promela file successfully created at " + pf.getAbsolutePath()+"!");
			} catch (IOException e) {
				String message = "File " + pf.getAbsolutePath() + " not found";
				//JOptionPane.showMessageDialog(null, message, "File not found!", JOptionPane.ERROR_MESSAGE);
				System.out.println(message);
				e.printStackTrace();
			}
		} else {
			String message = "This functionality has been developed for Kernel P Systems!" +
					"\nIt is not available for other models.";
			System.out.println(message);
			//JOptionPane.showMessageDialog(null, message, "Non-compatible model", JOptionPane.WARNING_MESSAGE);				
		}
	}

	private void runSpin() {
		// TODO Auto-generated method stub
		String userDir = "userfiles/";
		String promelaFilename = "promela-file.pml";
		String spinFilename = "spin-output-file.txt";
		runSpinSimulation(promelaFilename,spinFilename,userDir);
	}
	
	public static void runSpinSimulation(String inputPath, String outputPath, String userDir) {
		PrintStream output = null;
		BufferedReader stdInput = null, stdError = null;
		try {
			Runtime run = Runtime.getRuntime();
			Process p = null;
			if (p != null) {
				p.destroy();
			}
			String commandLine = "spin -s -T " + inputPath;
					//"spin -p -s -r -X -v -n123 -l -g -u10000 " + inputPath;
			System.out.println(commandLine);
			p = run.exec(commandLine,null,new File(userDir));
			
			stdInput = new BufferedReader(new 
	                 InputStreamReader(p.getInputStream()));

	        stdError = new BufferedReader(new 
	                 InputStreamReader(p.getErrorStream()));
	        
	        output = new PrintStream(
	        			new BufferedOutputStream(
	        					new FileOutputStream(new File(userDir + outputPath), false)));
    		
            // read the output from the command
            //String message = "Here is the standard output of the command:\n";
            //System.out.println(message);
            /* Comentado para ver nuevo archivo resultante de Spin: 
             * output.println(message);
             */
            
            String s = stdInput.readLine();
            while (s != null && !s.equals("spin: type return to proceed")) {// && !s.contains("processes")) {
                //System.out.println(s);
                /* Comentado para ver nuevo archivo resultante de Spin: 
                 * output.println(s);
                 */
            	if (!s.trim().equals("") && !s.contains("processes"))
            		output.println(s);
                s = stdInput.readLine();
            }
            
            if (s != null && !s.equals("spin: type return to proceed")){
	            // read any errors from the attempted command
	            //System.out.println("Here is the standard error of the command (if any):\n");
	            s = stdError.readLine();
	            while (s != null) {
	                //System.out.println(s);
	                output.println(s);
	                s = stdError.readLine();
	            }
            }
            output.close();
            p.destroy();
		} catch (IOException e) {
            System.out.println("exception happened - here's what I know: ");
            e.printStackTrace();
        	if (output != null)
				output.close();
            //System.exit(-1);
        } finally {
        	try {
        		if (stdInput == null)
        			stdInput.close();
        		if (stdError == null)
        			stdError.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
        }
	}

	@Override
	protected String getHead(ChangeableMembrane m) {
		// TODO Auto-generated method stub
		String str;
		str="CELL ID: "+m.getId();
		str += ", Label: " + m.getLabelObj();
		return str;
	}
	
	

	@Override
	protected void microStepInit() {
		// TODO Auto-generated method stub
		super.microStepInit();
		structure = (SimpleKernelLikeMembraneStructure)getPsystem().getMembraneStructure();
		membranesToDivide.clear();
		evolutionRules.clear();
		inputOutputRules.clear();
		state=STATE_SELECT_COMMUNICATION;
		if (!launched){
			generatePromelaFile();
			runSpin();
			launched = true;
		}
	}

	@Override
	protected void microStepSelectRules(Configuration cnf, Configuration tmpCnf) {
		// TODO Auto-generated method stub
		/*for (int i=EVOLUTION_AND_COMMUNICATION_STAGE;i<=DIVISION_STAGE;i++)
		{
			if (i==INPUT_OUTPUT_STAGE)
				state = STATE_SELECT_INPUT_OUTPUT;
			else if (i==DIVISION_STAGE)
				state = STATE_SELECT_DIVISION;
			Iterator<? extends Membrane> it = tmpCnf.getMembraneStructure().getAllMembranes().iterator();
			Iterator<? extends Membrane> it1 = cnf.getMembraneStructure().getAllMembranes().iterator();
			while(it.hasNext())
			{
				ChangeableMembrane tempMembrane = (ChangeableMembrane) it.next();
				ChangeableMembrane m = (ChangeableMembrane)it1.next();
				microStepSelectRules(m,tempMembrane);
			}
		}*/
	}

	@Override
	protected void microStepSelectRules(ChangeableMembrane m,
			ChangeableMembrane temp) {
		/*Iterator<IRule> it = getPsystem().getRules().iterator(temp.getLabel(),
				temp.getCharge(),true);

		while (it.hasNext()) {
			IRule r = it.next();
			
			structure = (SimpleKernelLikeMembraneStructure)((TissueLikeMembrane)m).getStructure();
			
			DivisionKernelLikeRule r1 = (DivisionKernelLikeRule)r;
			r1.setMembraneStructure(structure);
			if (state==STATE_SELECT_COMMUNICATION && (r instanceof EvolutionCommunicationKernelLikeRule) && !isDivision(r)) {					
				selectEvolutionCommunicationRule(m, temp, r1);
			} else if (state==STATE_SELECT_DIVISION && isDivision(r) 
					&& !membranesToDivide.containsKey(m.getId())) {
				selectDivisionRule(m, temp, r1);
			} else if (state==STATE_SELECT_INPUT_OUTPUT && 
					(r instanceof InputOutputKernelLikeRule)){
				selectInputOutputRule(m, temp, r1);
			}
		}*/
		
	}

	protected void selectDivisionRule(ChangeableMembrane m,
			ChangeableMembrane temp, DivisionKernelLikeRule r) {
		/*long count = r.countExecutions(temp,m);
		if (count>0)
		{
			count=1;
			selectRule(r, m, count);
			membranesToDivide.put(m.getId(),new Triple<DivisionKernelLikeRule,ChangeableMembrane,Long>(r,m,count));
			removeLeftHandRuleObjects(temp, r, count);
			*/
	}

	protected void selectEvolutionCommunicationRule(ChangeableMembrane m,
			ChangeableMembrane temp, DivisionKernelLikeRule r1) {
		/*r1.setMembraneStructure(structure);
		long count = r1.countExecutions(temp,m);
		if (count>0)
		{

				selectRule(r1, m, count);
				removeLeftHandRuleObjects(temp, r1,count);
			evolutionRules.add(new Triple<EvolutionCommunicationKernelLikeRule, ChangeableMembrane, Long>((EvolutionCommunicationKernelLikeRule)r1, m,count));
		}*/
	}

	protected void selectInputOutputRule(ChangeableMembrane m,
			ChangeableMembrane temp, DivisionKernelLikeRule r1) {
		/*r1.setMembraneStructure(structure);
		long count = r1.countExecutions(temp,m);
		if (count>0)
		{
				selectRule(r1, m, count);
				removeLeftHandRuleObjects(temp, r1,count);
			inputOutputRules.add(new Triple<InputOutputKernelLikeRule, ChangeableMembrane, Long>((InputOutputKernelLikeRule)r1, m,count));
		}*/
	}

	private boolean isDivision(IRule r) {		
		return (!(r instanceof EvolutionCommunicationKernelLikeRule) &&
				!(r instanceof InputOutputKernelLikeRule));
	}

	protected TissueLikeMembrane getMembraneByLabel(
			DivisionKernelLikeRule r1,
			TissueLikeMembraneStructure structure) {
		Iterator<TissueLikeMembrane> it = structure.iterator(r1.getRightHandRule().getOuterRuleMembrane().getLabelObj().getLabelID());
		TissueLikeMembrane tlm = null;
		if (it.hasNext()){
			tlm = it.next();
		}
		
		return tlm;
	}

	protected boolean isEvolution(IRule r){
		return r.getLeftHandRule().getOuterRuleMembrane().getLabel().equals(r.getRightHandRule().getOuterRuleMembrane().getLabel());
	}
	
	protected RulesSet filterRules(Iterator<IRule> iterator, ChangeableMembrane m) {
		RulesSet returnedRuleSet = new RulesSet();
		while(iterator.hasNext()){
			IKernelRule rule= (IKernelRule) iterator.next();
			if(rule.guardEvaluates(m))
				returnedRuleSet.add(rule);
		}
		return returnedRuleSet;
	}

	@Override
	protected void microStepExecuteRules() {
		/*executeEvolutionCommunicationRules();
		executeInputOutputRules();
		executeDivisionRules();*/		
	}

	protected void executeDivisionRules() {
		/*Iterator<Triple<DivisionKernelLikeRule,ChangeableMembrane,Long>>it1 = membranesToDivide.values().iterator();
		while(it1.hasNext())
		{
			Triple<DivisionKernelLikeRule,ChangeableMembrane,Long>p = it1.next();
			p.getFirst().execute(p.getSecond(), null);
		}*/
	}

	protected void executeEvolutionCommunicationRules() {
		/*for(Triple<EvolutionCommunicationKernelLikeRule, ChangeableMembrane, Long> Triple: evolutionRules){
			EvolutionCommunicationKernelLikeRule r1 = Triple.getFirst();
			ChangeableMembrane m = Triple.getSecond();
			//long count = r1.countExecutions(m,original);
			long count = Triple.getThird();
			TissueLikeMembrane tlm = getMembraneByLabel(r1, structure);
			if (tlm != null)
				r1.setRightHandMembrane(tlm);
			r1.execute(structure.getCell(m.getId()), currentConfig.getEnvironment(), count);
		}*/
	}
	
	protected void executeInputOutputRules() {
		/*for(Triple<InputOutputKernelLikeRule, ChangeableMembrane, Long> Triple: inputOutputRules){
			InputOutputKernelLikeRule r1 = Triple.getFirst();
			ChangeableMembrane m = Triple.getSecond();
			//long count = r1.countExecutions(m,original);
			long count = Triple.getThird();
			r1.execute(structure.getCell(m.getId()), currentConfig.getEnvironment(), count);
		}*/
	}

	@Override
	protected void printInfoMembraneShort(MembraneStructure membraneStructure) {
		// TODO Auto-generated method stub
		/*Iterator<? extends Membrane>it = membraneStructure.getAllMembranes().iterator();
		while(it.hasNext())
			printInfoMembrane((ChangeableMembrane)it.next());*/
	}

	@Override
	protected void printInfoMembrane(ChangeableMembrane membrane) {
		// TODO Auto-generated method stub
		TissueLikeMembrane tlm = (TissueLikeMembrane)membrane;
		if (!tlm.getLabel().equals(tlm.getStructure().getEnvironmentLabel()))
		{
			getInfoChannel().println("    " + getHead(membrane));
			getInfoChannel().println("    Multiset: " + membrane.getMultiSet());
			getInfoChannel().println();
		}
	}
	

	@Override
	protected void removeLeftHandRuleObjects(ChangeableMembrane membrane,
			IRule r, long count) {
		// TODO Auto-generated method stub
		/*MultiSet<String>ms = r.getLeftHandRule().getOuterRuleMembrane().getMultiSet();
		if (!ms.isEmpty())
			membrane.getMultiSet().subtraction(ms, count);*/
	}

}
