package org.gcn.plinguacore.parser.input.plingua;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;

import org.gcn.plinguacore.parser.input.plingua.PlinguaJavaCcParser.Range;
import org.gcn.plinguacore.util.HashMultiSet;
import org.gcn.plinguacore.util.MultiSet;
import org.gcn.plinguacore.util.psystem.Label;
import org.gcn.plinguacore.util.psystem.rule.OuterRuleMembrane;
import org.gcn.plinguacore.util.psystem.rule.guard.AndJoinedGuard;
import org.gcn.plinguacore.util.psystem.rule.guard.Guard;
import org.gcn.plinguacore.util.psystem.rule.guard.LogicOperatedGuard;
import org.gcn.plinguacore.util.psystem.rule.guard.OrJoinedGuard;
import org.gcn.plinguacore.util.psystem.rule.guard.UnitGuard;

import sun.rmi.runtime.Log;

public class ObjectRangeExpander {
	
	protected static boolean checkSafeMode(PlinguaEnvironment environment, List<Range> rangeList){
		if(environment.isSafeMode()){
			ListIterator<Range> rangesIterator = rangeList.listIterator();
			Range currentRange = rangesIterator.next();
			String variable = currentRange.variable;
			environment.setVariable(variable, 0);
			return true;
		}
		return false;
	}
	public static void expandObject(MultiSet<String> ms, List<Range> rangeList, Stack<Token> ranges, PlinguaEnvironment environment, Set<String> nonCheckedVariables) throws PlinguaSemanticsException, ObjectRangeException{
		if(checkSafeMode(environment, rangeList)) return;			
		MultiSet<String> objectsToAdd = new HashMultiSet<String>();
		MultiSet<String> objectsToRemove = new HashMultiSet<String>();
		for(int h=0; h<rangeList.size(); h++){

		for(String object : ms){
			String replacedObject=object;
			ListIterator<Range> rangesIterator = rangeList.listIterator();
			while(rangesIterator.hasNext())
			{
 
				Range currentRange = rangesIterator.next();
				String variable = currentRange.variable;
				//nonCheckedVariables.remove(variable);
				int begin, end;
					begin = currentRange.beginNumber.intValue();
				if(currentRange.firstOperation==Range.LESS_OPERATION) begin++;
					end = currentRange.endNumber.intValue();
				if(currentRange.secondOperation==Range.LESS_OPERATION) end--;
				boolean changed=false;
				String originalObject = object; 
				for(int i= begin; i<=end; i++)
				{
					
					String previousObject=originalObject;
						replacedObject = replaceIndex(variable, i,
								previousObject);
					
						
						/*if (replacedObject.contains(""+(n+1)))
							throw new ObjectRangeException();*/
						if(originalObject.equals(replacedObject)){
							int n = PlinguaEnvironment.unknownValAssociations.get(variable);
							replacedObject = replaceIndex(n+"", i, previousObject);
						}
					boolean localChanged = !replacedObject.equals(previousObject);
					changed|=localChanged;
						if(localChanged){
							objectsToAdd.add(replacedObject, ms.count(originalObject));
							objectsToAdd.remove(originalObject);
						}
						
				}
				if(changed)
						objectsToRemove.add(originalObject);
			}
				
			}
	
			
			ms.addAll(objectsToAdd);
			ms.removeAll(objectsToRemove);
		}
		for(String object : ms)
			checkCompositeValues(object);


		}

	protected static void checkCompositeValues(String variable) throws ObjectRangeException{
		for(int value : PlinguaEnvironment.unknownValAssociations.values()){
			if(variable.contains(value+""))
				throw new ObjectRangeException("Rule ranged indexes should be simple variables");
			
		}
	}
	protected static String replaceIndex(String variable, int i,
			String previousObject) {
		String replacedObject;
		replacedObject = previousObject.replaceAll("\\{"+variable+"\\}", "\\{"+i+"\\}");
		replacedObject = replacedObject.replaceAll("\\{"+variable+",", "\\{"+i+",");
		replacedObject = replacedObject.replaceAll(","+variable+",", ","+i+",");
		replacedObject = replacedObject.replaceAll(","+variable+"\\}", ","+i+"\\}");
		return replacedObject;
	}
	
	
	public static Range processRanges(Stack<Token> ranges, List<Range> rangeList, PlinguaEnvironment environment, boolean diff, boolean op1, boolean op2, Token rangeToken, Number n1, Number n2, String variable){
	    if (ranges != null)
	    {
	      if (!diff) ranges.push(rangeToken);
	      else ranges.add(0, rangeToken);
	    }
	    Range builtRange = new Range(n1, op1, variable, op2, n2);
	    if(rangeList!=null) rangeList.add(builtRange);
	    return environment.isSafeMode() ? null : builtRange;
	}

	public static LogicOperatedGuard expandGuard(LogicOperatedGuard logicOperatedGuard,
			List<Range> rangeList, Stack<Token> ranges,
			PlinguaEnvironment currentEnvironment,
			Set<String> nonCheckedVariables, boolean joinByAnd) throws PlinguaSemanticsException, ObjectRangeException{
		if(checkSafeMode(currentEnvironment, rangeList)) return null;	
		
		ListIterator<Range> rangesIterator = rangeList.listIterator();
		List<String> guardStrings = new LinkedList<String>();
		guardStrings.add(logicOperatedGuard.toString());
		while(rangesIterator.hasNext()){
			Range currentRange = rangesIterator.next();
			String variable = currentRange.variable;
			int begin, end;
			begin = currentRange.beginNumber.intValue();
			if(currentRange.firstOperation==Range.LESS_OPERATION) begin++;
			end = currentRange.endNumber.intValue();
			if(currentRange.secondOperation==Range.LESS_OPERATION) end--;
			
			List<String> newGuardStrings = new LinkedList<String>();
			for(int i= begin; i<=end; i++)
			{
				for (String currentGuard : guardStrings){
					if (currentGuard == null){
						throw new ObjectRangeException("Range operation <> not allowed in guard ranges");
					}
					String newGuard = replaceIndex(variable, i, currentGuard);
					if(newGuard.equals(currentGuard)){
					int n = PlinguaEnvironment.unknownValAssociations.get(variable);
						newGuard = replaceIndex(n+"", i, newGuard);
					}
					newGuardStrings.add(newGuard);
				}				
			}
			guardStrings = newGuardStrings;
			
		}
		
		LogicOperatedGuard resultingGuard = null;
		if (!joinByAnd)
			resultingGuard = new OrJoinedGuard();
		else
			resultingGuard = new AndJoinedGuard();
		for(String guardString : guardStrings)
			checkCompositeValues(guardString);
		for (String guardString : guardStrings){
			resultingGuard.addGuard(new AndJoinedGuard(guardString));
		}
		
		return resultingGuard;
		
	}
	
	public static void expandMembranes(List<OuterRuleMembrane> nonLabelledMembranes,
			List<Range> rangeList, Stack<Token> ranges,
			PlinguaEnvironment currentEnvironment,
			Set<String> nonCheckedVariables) throws PlinguaSemanticsException, ObjectRangeException, CloneNotSupportedException{
		if(checkSafeMode(currentEnvironment, rangeList)) return;	
		List<OuterRuleMembrane> membranesToAdd = new LinkedList<OuterRuleMembrane>();
		List<OuterRuleMembrane> membranesToRemove = new LinkedList<OuterRuleMembrane>();
		for(int h=0; h<rangeList.size(); h++){

			for(OuterRuleMembrane membrane : nonLabelledMembranes){
				ListIterator<Range> rangesIterator = rangeList.listIterator();
				while(rangesIterator.hasNext())
				{
	 
					Range currentRange = rangesIterator.next();
					String variable = currentRange.variable;
					//nonCheckedVariables.remove(variable);
					int begin, end;
					begin = currentRange.beginNumber.intValue();
					if(currentRange.firstOperation==Range.LESS_OPERATION) begin++;
					end = currentRange.endNumber.intValue();
					if(currentRange.secondOperation==Range.LESS_OPERATION) end--;
					boolean changed=false;
					OuterRuleMembrane originalMembrane = membrane; 
					for(int i= begin; i<=end; i++)
					{
						String previousLabel = originalMembrane.getLabel();
						OuterRuleMembrane previousMembrane=(OuterRuleMembrane)originalMembrane.clone();
						replaceMembrane(variable, i, previousMembrane);
						if(previousLabel.equals(previousMembrane.getLabel())){
							if(PlinguaEnvironment.unknownValAssociations.containsKey(variable)){
								int n = PlinguaEnvironment
										.unknownValAssociations
										.get(variable);
								replaceMembrane(n+"", i, previousMembrane);
							}
						}
						boolean localChanged = !previousLabel.equals(previousMembrane.getLabel());
						changed|=localChanged;
						if(localChanged){
							membranesToAdd.add(previousMembrane);
							membranesToAdd.remove(originalMembrane);
						}
						
					}
					if(changed)
						membranesToRemove.add(originalMembrane);
				}
				
			}
	
			
			nonLabelledMembranes.addAll(membranesToAdd);
			nonLabelledMembranes.removeAll(membranesToRemove);
		}
		for(OuterRuleMembrane membrane : nonLabelledMembranes)
			checkCompositeValues(membrane.getLabel());
	}
	private static void replaceMembrane(String variable, int i,
			OuterRuleMembrane previousMembrane) {
		// TODO Auto-generated method stub
		previousMembrane.setLabel(new Label(previousMembrane.getLabel().replaceAll(variable, ""+i)));
	}


}
