package org.gcn.plinguacore.simulator.cellLike.probabilistic.bddcb;

import java.util.Map;

import org.gcn.plinguacore.simulator.cellLike.probabilistic.AbstractProbabilisticSimulator;
import org.gcn.plinguacore.util.ExtendedLinkedHashSet;
import org.gcn.plinguacore.util.psystem.Configuration;
import org.gcn.plinguacore.util.psystem.Psystem;
import org.gcn.plinguacore.util.psystem.cellLike.CellLikeConfiguration;
import org.gcn.plinguacore.util.psystem.membrane.ChangeableMembrane;

public class BDDCBProbabilisticSimulator extends AbstractProbabilisticSimulator {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5683365879577783767L;
	private DynamicMatrix matrix;
	private long selectedRules=0;
	private boolean showRules=true;
	


	public BDDCBProbabilisticSimulator(Psystem psystem) {
		super(psystem);
		matrix = new DynamicMatrix(psystem);

		// TODO Auto-generated constructor stub
	}

	
	
	
	
	public boolean isShowRules() {
		return showRules;
	}





	public void setShowRules(boolean showRules) {
		this.showRules = showRules;
	}





	@Override
	protected boolean hasSelectedRules() {
		// TODO Auto-generated method stub
	
		return selectedRules!=0;
	}





	@Override
	protected void microStepSelectRules() {
		// TODO Auto-generated method stub
		CellLikeConfiguration cnf = (CellLikeConfiguration)currentConfig;
		selectedRules=0;
		for (String environment:matrix.getEnvironmentLabels().keySet())
		{
			
			
			matrix.filterColumns(cnf, environment);
			matrix.filterRows(cnf, environment);
			matrix.normalizeRowsAndCalculateMinimums(cnf, environment);
			System.out.println("Minimos antes de maximalidad:");
			for (MatrixColumn c:matrix.getColumns())
			{
				System.out.println(c.getMin());
			}
			
			matrix.removeLeftHandRuleObjects(cnf,environment);
			System.out.println("Minimos despues de maximalidad:");
			matrix.maximality(cnf, environment);
			for (MatrixColumn c:matrix.getColumns())
			{
				System.out.println(c.getMin());
			}
			selectedRules+=matrix.getSelectedRules();
			System.out.println(matrix);
		}
	
	}





	




	@Override
	protected void microStepExecuteRules() {
		// TODO Auto-generated method stub
		CellLikeConfiguration cnf = (CellLikeConfiguration)currentConfig;
		for (String environment:matrix.getEnvironmentLabels().keySet())
			matrix.executeRules(cnf,environment,this);
		
	}





	@Override
	protected void microStepSelectRules(ChangeableMembrane membrane,
			ChangeableMembrane tempMembrane) {
		// TODO Auto-generated method stub

	}

	public ExtendedLinkedHashSet<MatrixColumn> getBlocks(){
		return matrix.getColumns();
	}
}
