package org.gcn.plinguacore.applications;

import java.io.FileInputStream;
import java.io.FileNotFoundException;

import org.gcn.plinguacore.parser.AbstractParserFactory;
import org.gcn.plinguacore.parser.input.InputParser;
import org.gcn.plinguacore.parser.input.InputParserFactory;
import org.gcn.plinguacore.simulator.ISimulator;
import org.gcn.plinguacore.util.PlinguaCoreException;
import org.gcn.plinguacore.util.psystem.Psystem;

public class PruebaTest {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub
		args = new String[2];
		args[0]="ejemploProbabilistico2.pli";
		args[1]="bddcb";
		
		try {
			if (args.length!=2)
			{
				System.out.println("Número inválido de argumentos");
				System.exit(0);
			}
			String file = args[0];
		
			String alg=args[1];
			
			FileInputStream stream = new FileInputStream(file);

			try {
				AbstractParserFactory pf = new InputParserFactory();
				InputParser parser = (InputParser) pf.createParser("P-Lingua");

				parser.setVerbosityLevel(5);
				Psystem ps = parser.parse(stream);
			
				ISimulator sim = ps.createSimulator(false, false,alg);
				
				
				sim.setTimed(true);
				sim.setVerbosity(2);
				
				try
				{
					sim.runSteps(1);
				}catch(Exception ex)
				{
					ex.printStackTrace();
				}
				

			} catch (PlinguaCoreException ex) {
				// TODO Auto-generated catch block
				ex.printStackTrace();
			}
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		System.exit(0);
		
		
	}

}
