package org.gcn.plinguacore.simulator.cellLike.probabilistic.bddcb;

import java.util.HashMap;
import java.util.Map;

import org.gcn.plinguacore.util.MultiSet;
import org.gcn.plinguacore.util.psystem.cellLike.membrane.CellLikeNoSkinMembrane;
import org.gcn.plinguacore.util.psystem.cellLike.membrane.CellLikeSkinMembrane;
import org.gcn.plinguacore.util.psystem.membrane.Membrane;
import org.gcn.plinguacore.util.psystem.rule.IRule;

public class SkeletonRightHandRule extends SkeletonHandRule implements IRightHandRule,Cloneable{
	
	/* Probabilidad asociada a la regla según entorno */
	private Map<String,Float>probabilities=null;
	private Float defaultProbability=null;
	
	public SkeletonRightHandRule()
	{
		super();
	}
	
	public SkeletonRightHandRule(IRule r)
	{
		this (r.getRightHandRule().getOuterRuleMembrane().getCharge(),
				r.getRightHandRule().getOuterRuleMembrane().getMultiSet(),
				r.getRightHandRule().getMultiSet());
		
	}
	

	
	@Override
	public void set(IRule r)
	{
		setMainMembraneCharge(r.getRightHandRule().getOuterRuleMembrane().getCharge());
		setMainMultiSet(r.getRightHandRule().getOuterRuleMembrane().getMultiSet());
		setParentMultiSet(r.getRightHandRule().getMultiSet());
		
	}
	

	public SkeletonRightHandRule(byte mainMembraneCharge,
			MultiSet<String> mainMultiSet, MultiSet<String> parentMultiSet) {
		super(mainMembraneCharge, mainMultiSet, parentMultiSet);
		
		// TODO Auto-generated constructor stub
	}
	
	public void setProbability(String environment,float probability)
	{
		if (defaultProbability==null)
			defaultProbability=probability;
		else
		if (probability!=defaultProbability)
		{
			if (probabilities==null)
				probabilities=new HashMap<String,Float>();
			probabilities.put(environment, probability);
		}
	}
	@Override
	public float getProbability(String environment)
	{
		if (probabilities==null && defaultProbability==null)
			return 0;
		if (probabilities==null || !probabilities.containsKey(environment))
			return defaultProbability;
		
		return probabilities.get(environment);
		
	}

	

	@Override
	protected Object clone()  {
		// TODO Auto-generated method stub
		SkeletonRightHandRule o = new SkeletonRightHandRule(getMainMembraneCharge(),getMainMultiSet(),getParentMultiSet());
		if (defaultProbability!=null)
			o.defaultProbability=defaultProbability;
		if (probabilities!=null)
			o.probabilities = new HashMap<String,Float>(probabilities);
		return o;
	}

	@Override
	public String toString() {
		// TODO Auto-generated method stub
		String str=super.toString();
		if (defaultProbability!=null)
			str+=" {* ="+defaultProbability+"} ";
		if (probabilities!=null && !probabilities.isEmpty())
			str+=" "+probabilities.toString();
		return str;
		
	}

	@Override
	public void execute(CellLikeSkinMembrane ms, Map<String, Integer> map,
			String mainMembraneLabel, String environment, long multiplicity) {
		// TODO Auto-generated method stub
		CellLikeNoSkinMembrane m = (CellLikeNoSkinMembrane)StaticMethods.getMembrane(mainMembraneLabel, environment, ms, map);
	
		m.setCharge(getMainMembraneCharge());
		
		if (!getMainMultiSet().isEmpty())
			m.getMultiSet().addAll(getMainMultiSet(),multiplicity);
		
		if (!getParentMultiSet().isEmpty())
			m.getParentMembrane().getMultiSet().addAll(getParentMultiSet(),multiplicity);
	}

	@Override
	public String toString(String environment) {
		// TODO Auto-generated method stub
		String str=" --> ";
		str+=super.toString();
		str+=" :: "+getProbability(environment);
		
		return str;
	}

	

}
