package org.gcn.plinguacore.parser.output.promela;

import java.util.*;

import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

public class PromelaSTHelper {
	
	public static ST buildInitialMultiSets(STGroup template, Collection<Integer> indices, Collection<Integer> membraneTypes, 
			Collection<Collection<String>> symbolsList, Collection<Collection<Long>> countsList, int instanceCount) {
		return template.getInstanceOf("InitialMultiSets").add("indices", indices).add("membraneTypes", membraneTypes).add("symbolsList", symbolsList).
				add("countsList", countsList).add("instanceCount", instanceCount);
	}
	
	public static ST buildRelOpTemplate(STGroup template, String op, String left, String right) {
		ST relOpTemplate = null;
		switch(op) {
			case ">": relOpTemplate = template.getInstanceOf("Gt"); break;
			case ">=": relOpTemplate = template.getInstanceOf("Ge"); break;
			case "<": relOpTemplate = template.getInstanceOf("Lt"); break;
			case "<=": relOpTemplate = template.getInstanceOf("Le"); break;
			case "==": relOpTemplate = template.getInstanceOf("Eq"); break;
			default: relOpTemplate = template.getInstanceOf("Ne");
		}
		
		return relOpTemplate.add("left", left).add("right", right);
	}
	
	public static ST buildSymbolTempate(STGroup template, String symbol) {
		return template.getInstanceOf("Symbol").add("symbol", symbol);
	}
	
	public static ST buildOrJoinedTemplate(STGroup template, List<String> items) {
		return template.getInstanceOf("OrJoined").add("items", items);
	}
	
	public static ST buildAndJoinedTemplate(STGroup template, List<String> items) {
		return template.getInstanceOf("AndJoined").add("items", items);
	}
	
	public static ST buildRuleLhs(STGroup template, Collection<String> symbols, Collection<Long> counts) {
		return template.getInstanceOf("RuleLhs").add("symbols", symbols).add("counts", counts);
	}
	
	public static ST buildRuleRhs(STGroup template, Collection<String> lhsSymbols, Collection<Long> lhsCounts, Collection<String> rhsRewSymbols, Collection<Long> rhsRewCounts,
			Collection<Integer> rhsCommMembraneTypes, Collection<String> rhsCommSymbols, Collection<Long> rhsCommCounts) {
		return template.getInstanceOf("RuleRhs").add("lhsSymbols", lhsSymbols).add("lhsCounts", lhsCounts)
				.add("rhsRewSymbols", rhsRewSymbols).add("rhsRewCounts", rhsRewCounts).add("rhsCommMembraneTypes", rhsCommMembraneTypes).
				add("rhsCommSymbols", rhsCommSymbols).add("rhsCommCounts", rhsCommCounts);
	}
	
	public static ST buildSymbolsMapping(STGroup template, Collection<String> symbols, Collection<Integer> indices, int symbolCount) {
		return template.getInstanceOf("SymbolsMapping").add("symbols", symbols).add("indices", indices)
				.add("symbolCount", symbolCount);
	}
}
