package org.gcn.plinguacore.parser.output.promela;

import java.util.*;

import org.gcn.plinguacore.util.psystem.rule.guard.*;
import org.stringtemplate.v4.STGroup;

public class PromelaGuardVisitor implements IGuardVisitor {
	
	private STGroup template;
	
	public PromelaGuardVisitor(STGroup template) {
		this.template = template;
	}

	@Override
	public String visit(UnitGuard guard) {
		String currentRelOp = getStringRelOp(guard.getRelOp());
		String relOp = guard.getSign() == ComparationMasks.MINUS ? getOpposedRelOp(currentRelOp) : currentRelOp;
		return PromelaSTHelper.buildRelOpTemplate(template, 
				relOp, 
				PromelaSTHelper.buildSymbolTempate(template, guard.getObj()).render(), 
				((Long)guard.getMul()).toString()).render();
	}

	@Override
	public String visit(OrJoinedGuard guard) {
		List<String> promelaGuards = new ArrayList<>();
		for(Guard g : guard.getGuards()) {
			promelaGuards.add(g.accept(this));
		}
		
		return PromelaSTHelper.buildOrJoinedTemplate(template, promelaGuards).render();
	}

	@Override
	public String visit(AndJoinedGuard guard) {
		List<String> promelaGuards = new ArrayList<>();
		for(Guard g : guard.getGuards()) {
			promelaGuards.add(g.accept(this));
		}
		
		return PromelaSTHelper.buildAndJoinedTemplate(template, promelaGuards).render();
	}
	
	protected String getStringRelOp(short relOp) {
		switch(relOp){
			case(ComparationMasks.EQUAL): return "==";
			case(ComparationMasks.LESS_THAN): return "<";
			case(ComparationMasks.LESS_OR_EQUAL_THAN): return "<=";
			case(ComparationMasks.GREATER_OR_EQUAL_THAN): return ">=";
			case(ComparationMasks.GREATER_THAN): return ">";
			case(ComparationMasks.DIFF): return "!=";
			default: return "";
		}
	}
	
	protected String getOpposedRelOp(String relOp) {
		switch(relOp) {
			case ">": return "<=";
			case ">=": return "<";
			case "<": return ">=";
			case "<=": return ">";
			case "==": return "!=";
			default: return "==";
		}
	}
}
