package org.gcn.plinguacore.simulator.cellLike.probabilistic.bddcb;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Map.Entry;

import org.gcn.plinguacore.util.RandomNumbersGenerator;
import org.gcn.plinguacore.util.ShuffleIterator;
import org.gcn.plinguacore.util.psystem.Psystem;
import org.gcn.plinguacore.util.psystem.cellLike.CellLikeConfiguration;
import org.gcn.plinguacore.util.psystem.cellLike.membrane.CellLikeSkinMembrane;
import org.gcn.plinguacore.util.psystem.membrane.ChangeableMembrane;
import org.gcn.plinguacore.util.psystem.membrane.Membrane;


public class DynamicMatrix extends StaticMatrix {

	private List<MatrixColumn> filterColumns;
	private List<MatrixRow> filterRows;
	private Map<String,Integer>membranes;
	private MatrixKey matrixKeyAux;
	private long selectedRules;
	
	private ArrayList<MatrixColumn>auxArrayList;
	private LinkedList<MatrixColumn>auxLinkedList;
	
	/* Nº de aplicaciones por entorno y bloque */
	private Map<String,Map<MatrixColumn,Long>>applications;

	
	public DynamicMatrix(Psystem ps) {
		super(ps);
		filterRows = new LinkedList<MatrixRow>();
		auxArrayList = new ArrayList<MatrixColumn>(getColumns().size());
		auxLinkedList = new LinkedList<MatrixColumn>();
		applications = new HashMap<String,Map<MatrixColumn,Long>>();
		membranes = StaticMethods.getMembraneIdsByLabelAndEnvironment((CellLikeSkinMembrane)ps.getMembraneStructure());
		matrixKeyAux=new MatrixKey();
		
		// TODO Auto-generated constructor stub
	}
	

	
	public List<MatrixRow> getFilterRows() {
		return filterRows;
	}
	
	
	public List<MatrixColumn> getFilterColumns() {
		return filterColumns;
	}

	
	/* step 1*/
	public void filterColumns(CellLikeConfiguration c1,String environment)
	{
		auxLinkedList.clear();
		filterColumns=auxLinkedList;
		for (MatrixColumn c:getColumns())
			if(c.retainColumn((CellLikeSkinMembrane)c1.getMembraneStructure(), membranes, environment))
			{
					c.setMin(Long.MAX_VALUE);
					filterColumns.add(c);
			}
	}
	
	/* step 2*/
	public void filterRows(CellLikeConfiguration c1,String environment)
	{
		filterRows.clear();
		
		for (MatrixRow r:getRows())
		{
			
			if ( r.retainRow((CellLikeSkinMembrane)c1.getMembraneStructure(), membranes, environment))
				filterRows.add(r);
			else
			{
				matrixKeyAux.setRow(r);
				Iterator<MatrixColumn>it = filterColumns.iterator();
				while(it.hasNext())
				{
					MatrixColumn c = it.next();
					matrixKeyAux.setColumn(c);
					if (getStaticMatrix().containsKey(matrixKeyAux))
						it.remove();
				}
				
			}
		}
	}
	/* step 3 */
	public void normalizeRowsAndCalculateMinimums(CellLikeConfiguration c1,String environment)
	{
		double sum;
		double multiplicity;
		for (MatrixRow r:filterRows)
		{
			sum=0;
		
			Membrane m = StaticMethods.getMembrane(r.getLabel(), environment, (CellLikeSkinMembrane)c1.getMembraneStructure(), membranes);
			if (m==null)
				multiplicity=0;
			else
				multiplicity=m.getMultiSet().count(r.getObject());
			matrixKeyAux.setRow(r);
			
			ListIterator<MatrixColumn>it = filterColumns.listIterator();
			while (it.hasNext())
			{
				MatrixColumn c = it.next();
				matrixKeyAux.setColumn(c);
				Double value = getStaticMatrix().get(matrixKeyAux);
				if (value!=null)
					sum+=value;
			}
			while (it.hasPrevious())
			{
				MatrixColumn c=it.previous();
				matrixKeyAux.setColumn(c);
				Double value = getStaticMatrix().get(matrixKeyAux);
				if (value!=null)
				{
					long normalizedValue =(long)Math.floor(multiplicity*value*value/sum);
					
					if (normalizedValue<c.getMin())
					
						c.setMin(normalizedValue);
				}
				
			}
			
			
		}
	}
	/* step 4 */
	public void removeLeftHandRuleObjects(CellLikeConfiguration c1,String environment)
	{
		selectedRules=0;
		Map<MatrixColumn,Long>app = applications.get(environment);
		if (app==null)
		{
			app = new HashMap<MatrixColumn,Long>();
			applications.put(environment,app);
		}
		else
			app.clear();
		
		
		auxArrayList.clear();
		for (MatrixColumn c:filterColumns)
		{
			selectedRules+=c.getMin();
			app.put(c, c.getMin());
			if (c.removeLeftHandRuleObjects((CellLikeSkinMembrane)c1.getMembraneStructure(),membranes,environment,c.getMin()))
				auxArrayList.add(c);
		}
		
		filterColumns=auxArrayList;
	
	
	}
	
	/* step 5 */
	public void maximality(CellLikeConfiguration c1,String environment)
	{
		
		Map<MatrixColumn,Long>app = applications.get(environment);
		
		
		ShuffleIterator<MatrixColumn> it = new ShuffleIterator<MatrixColumn>(filterColumns);
		while (it.hasNext())
		{
			MatrixColumn c = it.next();
			long applications = c.countApplications((CellLikeSkinMembrane)c1.getMembraneStructure(),membranes,environment);
			if (applications>0)
			{
				c.removeLeftHandRuleObjects((CellLikeSkinMembrane)c1.getMembraneStructure(),membranes,environment,applications);
				c.setMin(c.getMin()+applications);
				selectedRules+=applications;
				app.put(c, c.getMin());
			}
			
		
		}
		
		
	}
	
	
	public long getSelectedRules() {
	
		return selectedRules;
	}



	/* step 6 */
	public void executeRules(CellLikeConfiguration c1,String environment,BDDCBProbabilisticSimulator sim)
	{
		Map<MatrixColumn,Long>app = applications.get(environment);
		for (Entry<MatrixColumn,Long>entry:app.entrySet())
		{
			MatrixColumn c = entry.getKey();
			long N = entry.getValue();
			double d = 1.0;
			for (IRightHandRule rhr:c.getRightHandRules())
			{
				long n;
				if (N==0)
					n=0;
				else
				{
					double p = rhr.getProbability(environment);
					if (p==0)
						n=0;
					else
					if (p==1)
						n=N;
					else
					{
						p=p/d;
						double q = 1-p;
						d = d*q;
						if (d<0) d=0;
						if (p>=1)
							n=N;
						else
							n = RandomNumbersGenerator.getInstance().nextLongBi(N,p);
					}
				}
				if (n>0)
				{
					rhr.execute((CellLikeSkinMembrane)c1.getMembraneStructure(), membranes, c.getMainLabel(), environment,n);
					long resto=N-n;
					if (resto<0) resto=0;
					N=resto;
					
					if (sim.isShowRules())
					{
						String str = c.leftHandRuleToString()+rhr.toString(environment);
						ChangeableMembrane m= (ChangeableMembrane)StaticMethods.getMembrane(c.getMainLabel(), environment, (CellLikeSkinMembrane)c1.getMembraneStructure(), membranes);
						sim.selectRule(str, m, n);
					}
					
				}
					
				
			}
			
			
		}
		
	}
	
	
	
	
	
	
	
	
}
