/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

public class Main {
    private static final String CONFIG_FILE_PATH = "prop/config-properties";

    public static void main(String[] args) {
        Process p = null;
        BufferedReader stdOutChildProccess = null;
        BufferedReader stdErrChildProccess = null;
        String lineOut = null;
        String lineErr = null;
        String maxMemory = null;
        String appParams = null;
        String encoding = null;
        String language = null;
        String os = null;
        System.out.println("Reading operative system data...");
        try {
            os = System.getProperty("os.name").toLowerCase();
        }
        catch (Exception e) {
            os = null;
        }
        encoding = os == null || os.equals("") ? "" : (os.startsWith("linux") ? "" : (os.startsWith("windows") ? "-Dfile.encoding=cp850 " : ""));
        language = "-Duser.language=en -Duser.region= ";
        System.out.println("Accessing to properties file...");
        Properties properties = Main.getProperties();
        try {
            maxMemory = Main.getProperty(properties, "java-max-memory");
            Integer.parseInt(maxMemory);
            maxMemory = "-Xmx" + maxMemory + "m ";
        }
        catch (UnavailablePropertyException ex) {
            System.out.println("Parse Params: java-max-memory not found. Taking default value.");
            maxMemory = "-Xmx512m ";
        }
        catch (NullPointerException ex) {
            System.out.println("Parse Params: java-max-memory is not an integer. Taking default value.");
            maxMemory = "-Xmx512m ";
        }
        catch (NumberFormatException ex) {
            System.out.println("Parse Params: java-max-memory is not an integer. Taking default value.");
            maxMemory = "-Xmx512m ";
        }
        catch (Exception ex) {
            System.out.println("Parse Params: java-max-memory unexpected error. Taking default value.");
            maxMemory = "-Xmx512m ";
        }
        try {
            appParams = Main.getProperty(properties, "mecosim-params");
            if (appParams == null || appParams.equals("")) {
                System.out.println("Parse Params: mecosim-params inexistent value. Taking default value.");
                appParams = "ce 1";
            }
        }
        catch (UnavailablePropertyException ex) {
            System.out.println("Parse Params: mecosim-params not found. Taking default value.");
            appParams = "ce 1";
        }
        catch (Exception ex) {
            System.out.println("Parse Params: mecosim-params unexpected error. Taking default value.");
            appParams = "ce 1";
        }
        String command = "java -jar " + maxMemory + encoding + language + "MeCoSim2.0.jar " + appParams;
        System.out.println("Launching...");
        try {
            p = Runtime.getRuntime().exec(command);
            stdOutChildProccess = new BufferedReader(new InputStreamReader(p.getInputStream()));
            lineOut = stdOutChildProccess.readLine();
            while (lineOut != null) {
                System.out.println(lineOut);
                lineOut = stdOutChildProccess.readLine();
            }
            stdErrChildProccess = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            lineErr = stdErrChildProccess.readLine();
            while (lineErr != null) {
                System.out.println(lineErr);
                lineErr = stdErrChildProccess.readLine();
            }
        }
        catch (IOException e) {
            System.err.println("Launching error.");
            e.printStackTrace();
        }
    }

    private static Properties getProperties() {
        Properties properties = new Properties();
        InputStreamReader in = null;
        try {
            try {
                in = new InputStreamReader(new FileInputStream(CONFIG_FILE_PATH));
            }
            catch (FileNotFoundException e) {
                System.out.println("Properties file not found...");
            }
            try {
                properties.load(in);
            }
            catch (IOException e) {
                System.out.println("Problem loading file properties...");
            }
            catch (NullPointerException e) {
                System.out.println("Problem loading file properties...");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private static String getProperty(Properties properties, String name) throws UnavailablePropertyException {
        String value = (String)properties.get(name);
        if (value == null) {
            throw new UnavailablePropertyException(value);
        }
        return value;
    }
}

