package org.gcn.plinguacore.util.psystem.rule.guard;

import java.util.LinkedList;
import java.util.List;

import org.gcn.plinguacore.util.MultiSet;

public abstract class LogicOperatedGuard extends Guard {

	protected List<Guard> guards;
	
	public LogicOperatedGuard(){
		guards=new LinkedList<Guard>();
	}
	
	public LogicOperatedGuard(String representation){
		this();
		String componentGuards[] = representation.split(getOperator());
		for(int i=0; i<componentGuards.length; i++)
			addGuard(createGuardElement(componentGuards[i]));
	}

	protected abstract Guard createGuardElement(String guardRepresentation);

	public void addGuard(Guard guard){
		this.guards.add(guard);
	}

	@Override
	public void setMultiSet(MultiSet<String> multiSet) {
		// TODO Auto-generated method stub
		super.setMultiSet(multiSet);
		for(Guard guard: guards)
			guard.setMultiSet(multiSet);
	}
	
	public String toString(){
		String accumulator="";
		
		for(Guard guard: guards){
			accumulator+=guard.toString()+getOperator();
		}
		accumulator=accumulator.substring(0, accumulator.lastIndexOf(getOperator()));
		return accumulator;
		
	}
	
	protected abstract String getOperator();

	public List<Guard> getGuards() {
		return guards;
	}
}
