package org.gcn.plinguacore.util.psystem.kernel.membrane;

import java.util.LinkedList;
import java.util.List;

import org.gcn.plinguacore.util.psystem.Label;
import org.gcn.plinguacore.util.psystem.membrane.MembraneStructure;
import org.gcn.plinguacore.util.psystem.tissueLike.membrane.TissueLikeMembrane;
import org.gcn.plinguacore.util.psystem.tissueLike.membrane.TissueLikeMembraneStructure;

public class KernelLikeMembraneStructure extends TissueLikeMembraneStructure {

	public KernelLikeMembraneStructure(MembraneStructure membrane) {
		super(membrane);
		// TODO Auto-generated constructor stub
	}
	
	public void updateMembranes(String parentLabel){
		List<TissueLikeMembrane> affectedMembranes = cells.get(parentLabel);
		List<TissueLikeMembrane> newMembranes = new LinkedList<TissueLikeMembrane>();
		for(TissueLikeMembrane membrane : affectedMembranes){
			if(!membrane.getLabel().equals(parentLabel))
				newMembranes.add(membrane);
		}
		affectedMembranes.removeAll(newMembranes);
		for(TissueLikeMembrane membrane : newMembranes){
			if(!cells.containsKey(membrane.getLabel())){
				List<TissueLikeMembrane> createdMembranes = new LinkedList<TissueLikeMembrane>();
				createdMembranes.add(membrane);
				cells.put(membrane.getLabel(), createdMembranes);
			}
			else
				cells.get(membrane.getLabel()).add(membrane);
		}
		
	}
	
	@Override
	public Object clone()
	{
		return new KernelLikeMembraneStructure(this);
	}

}
