package org.gcn.plinguacore.applications;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.gcn.plinguacore.parser.AbstractParserFactory;
import org.gcn.plinguacore.parser.input.InputParser;
import org.gcn.plinguacore.parser.input.InputParserFactory;
import org.gcn.plinguacore.simulator.ISimulator;
import org.gcn.plinguacore.util.PlinguaCoreException;
import org.gcn.plinguacore.util.psystem.Psystem;


public class PruebaProbabilistic {

	public static void main(String[] args) {

		args = new String[4];
		args[0]="ejemploProbabilistico2.pli";
		args[1]="dndp2";
		args[2]="1000";
		args[3]="1000"; 
		
		try {
			if (args.length!=4)
			{
				System.out.println("Número inválido de argumentos");
				System.out.println("java -jar dndp.jar nombreFichero [dndp|dndp2|dndp-seq|dndp2-seq] simulaciones pasos_por_simulacion");
				System.out.println("Ejemplo:");
				System.out.println("java -jar dndp.jar input.pli dndp2-seq 100 100");
				System.exit(0);
			}
			String file = args[0];
		
			String alg=args[1];
			
			int N=Integer.parseInt(args[2]);
			int M=Integer.parseInt(args[3]);
					
			
			FileInputStream stream = new FileInputStream(file);

			try {
				AbstractParserFactory pf = new InputParserFactory();
				InputParser parser = (InputParser) pf.createParser("P-Lingua");

				parser.setVerbosityLevel(5);
				Psystem ps = parser.parse(stream);
			
				ISimulator sim = ps.createSimulator(false, false,alg);
				double ac_time=0;
				
				sim.setTimed(true);
				sim.setVerbosity(0);
				
				try
				{
				for(int i=0;i<N;i++)
				{
					sim.runSteps(M);
					double time = sim.getTime();
					System.out.println("Simulación nº "+(i+1));
					System.out.println("TIEMPO:");
					System.out.println(time);
					ac_time+=sim.getTime();
					sim.reset();
				}
				System.out.println(N+" simulaciones realizadas!!");
				
				System.out.println("Tiempo medio: "+(ac_time/N));
				}catch(Exception ex)
				{
					ex.printStackTrace();
				}
				

			} catch (PlinguaCoreException ex) {
				// TODO Auto-generated catch block
				ex.printStackTrace();
			}
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		System.exit(0);
		
		
	}

}
