package org.gcn.plinguacore.simulator.cellLike.probabilistic.bddcb;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.gcn.plinguacore.util.MultiSet;
import org.gcn.plinguacore.util.psystem.cellLike.CellLikeConfiguration;
import org.gcn.plinguacore.util.psystem.cellLike.membrane.CellLikeNoSkinMembrane;
import org.gcn.plinguacore.util.psystem.cellLike.membrane.CellLikeSkinMembrane;
import org.gcn.plinguacore.util.psystem.membrane.Membrane;
import org.gcn.plinguacore.util.psystem.rule.IRule;
import org.gcn.plinguacore.util.psystem.rule.InnerRuleMembrane;

public class EnvironmentRightHandRule implements IRightHandRule{
	
	private float probability=1;
	private Map<String,MultiSet<String>>newObjects;
	
	public EnvironmentRightHandRule()
	{
		newObjects=new HashMap<String,MultiSet<String>>();
	}

	
	public void set(IRule r)
	{
		setProbability(StaticMethods.getProbability(r));
		if (r.getRightHandRule().getOuterRuleMembrane().getInnerRuleMembranes().isEmpty())
		{
			if (!r.getRightHandRule().getOuterRuleMembrane().getMultiSet().isEmpty())
				newObjects.put(r.getRightHandRule().getOuterRuleMembrane().getLabel(), r.getRightHandRule().getOuterRuleMembrane().getMultiSet());
		}
		else
		for (InnerRuleMembrane irm:r.getRightHandRule().getOuterRuleMembrane().getInnerRuleMembranes())
		{
			if (!irm.getMultiSet().isEmpty())
				newObjects.put(irm.getLabel(), irm.getMultiSet());
		}
	}

	public void setProbability(float probability) {
		this.probability = probability;
	}

	public Map<String, MultiSet<String>> getNewObjects() {
		return newObjects;
	}

	@Override
	public String toString() {
		// TODO Auto-generated method stub
		String str="";
		for (Entry<String,MultiSet<String>> entry:newObjects.entrySet())
		{
			str+="("+entry.getValue()+")'"+entry.getKey()+" ";
		}
		str+="::"+probability;
		return str;
	}

	@Override
	public float getProbability(String environment) {
		// TODO Auto-generated method stub
		return probability;
	}


	@Override
	public void execute(CellLikeSkinMembrane ms, Map<String, Integer> map,String mainMembraneLabel,
			String environment, long multiplicity) {
		// TODO Auto-generated method stub
	
		for (Entry<String,MultiSet<String>>entry:newObjects.entrySet())
		{
			String e1=entry.getKey();
			MultiSet<String>ms1=entry.getValue();
			Membrane m = StaticMethods.getMembrane(e1, e1, ms, map);
			m.getMultiSet().addAll(ms1, multiplicity);
		}
	}


	@Override
	public String toString(String environment) {
		// TODO Auto-generated method stub
		String str=" -->";
		for (Entry<String,MultiSet<String>>entry:newObjects.entrySet())
		{
			str+=" ("+entry.getValue()+")'"+entry.getKey();
		}
		str+=" :: "+probability;
		return str;
	}


	



	
	

}
