/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import org.jdesktop.layout.LayoutStyle;

class SwingLayoutStyle
extends LayoutStyle {
    private static final Method SWING_GET_LAYOUT_STYLE_METHOD;
    private static final Method SWING_GET_PREFERRED_GAP_METHOD;
    private static final Method SWING_GET_CONTAINER_GAP_METHOD;
    private static final Object RELATED_TYPE;
    private static final Object UNRELATED_TYPE;
    private static final Object INDENT_TYPE;
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$java$awt$Container;

    SwingLayoutStyle() {
    }

    private static final Object layoutStyleTypeToComponentPlacement(int type) {
        if (type == 0) {
            return RELATED_TYPE;
        }
        if (type == 1) {
            return UNRELATED_TYPE;
        }
        return INDENT_TYPE;
    }

    private static final Object getSwingLayoutStyle() {
        try {
            return SWING_GET_LAYOUT_STYLE_METHOD.invoke(null, null);
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public int getPreferredGap(JComponent component1, JComponent component2, int type, int position, Container parent) {
        super.getPreferredGap(component1, component2, type, position, parent);
        Object componentPlacement = SwingLayoutStyle.layoutStyleTypeToComponentPlacement(type);
        Object layoutStyle = SwingLayoutStyle.getSwingLayoutStyle();
        try {
            return (Integer)SWING_GET_PREFERRED_GAP_METHOD.invoke(layoutStyle, component1, component2, componentPlacement, new Integer(position), parent);
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
        return 0;
    }

    public int getContainerGap(JComponent component, int position, Container parent) {
        super.getContainerGap(component, position, parent);
        Object layoutStyle = SwingLayoutStyle.getSwingLayoutStyle();
        try {
            return (Integer)SWING_GET_CONTAINER_GAP_METHOD.invoke(layoutStyle, component, new Integer(position), parent);
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Method getLayoutStyle = null;
        Method getPreferredGap = null;
        Method getContainerGap = null;
        Object relatedType = null;
        Object unrelatedType = null;
        Object indentType = null;
        try {
            Class<?> swingLayoutStyleClass = Class.forName("javax.swing.LayoutStyle");
            Class<?> swingComponentPlacementClass = Class.forName("javax.swing.LayoutStyle$ComponentPlacement");
            swingLayoutStyleClass = Class.forName("javax.swing.LayoutStyle");
            getLayoutStyle = swingLayoutStyleClass.getMethod("getInstance", null);
            getPreferredGap = swingLayoutStyleClass.getMethod("getPreferredGap", class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = SwingLayoutStyle.class$("javax.swing.JComponent")) : class$javax$swing$JComponent, class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = SwingLayoutStyle.class$("javax.swing.JComponent")) : class$javax$swing$JComponent, swingComponentPlacementClass, Integer.TYPE, class$java$awt$Container == null ? (class$java$awt$Container = SwingLayoutStyle.class$("java.awt.Container")) : class$java$awt$Container);
            getContainerGap = swingLayoutStyleClass.getMethod("getContainerGap", class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = SwingLayoutStyle.class$("javax.swing.JComponent")) : class$javax$swing$JComponent, Integer.TYPE, class$java$awt$Container == null ? (class$java$awt$Container = SwingLayoutStyle.class$("java.awt.Container")) : class$java$awt$Container);
            relatedType = swingComponentPlacementClass.getField("RELATED").get(null);
            unrelatedType = swingComponentPlacementClass.getField("UNRELATED").get(null);
            indentType = swingComponentPlacementClass.getField("INDENT").get(null);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (NoSuchFieldException nsfe) {
        }
        catch (IllegalAccessException iae) {
            // empty catch block
        }
        SWING_GET_LAYOUT_STYLE_METHOD = getLayoutStyle;
        SWING_GET_PREFERRED_GAP_METHOD = getPreferredGap;
        SWING_GET_CONTAINER_GAP_METHOD = getContainerGap;
        RELATED_TYPE = relatedType;
        UNRELATED_TYPE = unrelatedType;
        INDENT_TYPE = indentType;
    }
}

