/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class XMLCompositeDirectCollectionMapping
extends AbstractCompositeDirectCollectionMapping
implements XMLMapping {
    private boolean isCDATA;

    public boolean isXMLMapping() {
        return true;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        ContainerPolicy cp;
        super.initialize(session);
        if (this.getField() instanceof XMLField && this.getValueConverter() instanceof TypeConversionConverter) {
            TypeConversionConverter converter = (TypeConversionConverter)this.getValueConverter();
            this.getField().setType(converter.getObjectClass());
        }
        if ((cp = this.getContainerPolicy()) != null && cp.getContainerClass() == null) {
            Class cls = session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(cp.getContainerClassName());
            cp.setContainerClass(cls);
        }
        ((XMLField)this.getField()).setIsCDATA(this.isCDATA());
    }

    public void setXPath(String xpathString) {
        if (xpathString.indexOf("@") == -1 && !xpathString.endsWith("text()")) {
            xpathString = xpathString + "/text()";
        }
        this.setField(new XMLField(xpathString));
    }

    public String getXPath() {
        return this.getFieldName();
    }

    public void useCollectionClassName(String concreteContainerClassName) {
        this.setContainerPolicy(new CollectionContainerPolicy(concreteContainerClassName));
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        ContainerPolicy cp = this.getContainerPolicy();
        Object fieldValue = row.getValues(this.getField());
        if (fieldValue == null) {
            return cp.containerInstance();
        }
        Vector fieldValues = this.getDescriptor().buildDirectValuesFromFieldValue(fieldValue);
        if (fieldValues == null) {
            return cp.containerInstance();
        }
        Object result = cp.containerInstance(fieldValues.size());
        Enumeration stream = fieldValues.elements();
        while (stream.hasMoreElements()) {
            Object element = stream.nextElement();
            if (this.hasValueConverter()) {
                element = this.getValueConverter() instanceof XMLConverter ? ((XMLConverter)this.getValueConverter()).convertDataValueToObjectValue(element, executionSession, ((XMLRecord)row).getUnmarshaller()) : this.getValueConverter().convertDataValueToObjectValue(element, executionSession);
            }
            cp.addInto(element, result, sourceQuery.getSession());
        }
        return result;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            row.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Vector<Object> elements = new Vector<Object>(cp.sizeFor(attributeValue));
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            Object element = cp.next(iter, session);
            if (this.hasValueConverter()) {
                element = this.getValueConverter() instanceof XMLConverter ? ((XMLConverter)this.getValueConverter()).convertObjectValueToDataValue(element, session, ((XMLRecord)row).getMarshaller()) : this.getValueConverter().convertObjectValueToDataValue(element, session);
            }
            if (element == null) continue;
            elements.addElement(element);
        }
        Object fieldValue = null;
        if (!elements.isEmpty()) {
            fieldValue = this.getDescriptor().buildFieldValueFromDirectValues(elements, this.elementDataTypeName, session);
        }
        row.put(this.getField(), fieldValue);
    }

    public void writeSingleValue(Object value, Object parent, XMLRecord record, AbstractSession session) {
        Object element = value;
        if (this.hasValueConverter()) {
            element = this.getValueConverter() instanceof XMLConverter ? ((XMLConverter)this.getValueConverter()).convertObjectValueToDataValue(element, session, record.getMarshaller()) : this.getValueConverter().convertObjectValueToDataValue(element, session);
        }
        record.add(this.getField(), element);
    }

    public void setIsCDATA(boolean CDATA2) {
        this.isCDATA = CDATA2;
    }

    public boolean isCDATA() {
        return this.isCDATA;
    }
}

