/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.queries.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.StoredProcedureParameterMetadata;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.StoredProcedureCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedStoredProcedureQueryMetadata
extends NamedNativeQueryMetadata {
    private Boolean m_returnsResultSet;
    private List<StoredProcedureParameterMetadata> m_parameters = new ArrayList<StoredProcedureParameterMetadata>();
    private String m_procedureName;

    public NamedStoredProcedureQueryMetadata() {
        super("<named-stored-procedure_query>");
    }

    public NamedStoredProcedureQueryMetadata(Annotation namedStoredProcedureQuery, MetadataAccessibleObject accessibleObject) {
        super(namedStoredProcedureQuery, accessibleObject);
        for (Annotation storedProcedureParameter : (Annotation[])MetadataHelper.invokeMethod("parameters", namedStoredProcedureQuery)) {
            this.m_parameters.add(new StoredProcedureParameterMetadata(storedProcedureParameter, accessibleObject));
        }
        this.m_procedureName = (String)MetadataHelper.invokeMethod("procedureName", namedStoredProcedureQuery);
        this.m_returnsResultSet = (Boolean)MetadataHelper.invokeMethod("returnsResultSet", namedStoredProcedureQuery);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof NamedStoredProcedureQueryMetadata) {
            NamedStoredProcedureQueryMetadata query = (NamedStoredProcedureQueryMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_returnsResultSet, query.getReturnsResultSet())) {
                return false;
            }
            if (!this.valuesMatch(this.m_parameters, query.getParameters())) {
                return false;
            }
            return this.valuesMatch(this.m_procedureName, query.getProcedureName());
        }
        return false;
    }

    public String getProcedureName() {
        return this.m_procedureName;
    }

    public List<StoredProcedureParameterMetadata> getParameters() {
        return this.m_parameters;
    }

    public Boolean getReturnsResultSet() {
        return this.m_returnsResultSet;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.initXMLObjects(this.m_parameters, accessibleObject);
    }

    @Override
    public void process(AbstractSession session, ClassLoader loader) {
        StoredProcedureCall call = new StoredProcedureCall();
        ArrayList<String> queryArguments = new ArrayList<String>();
        for (StoredProcedureParameterMetadata parameter : this.m_parameters) {
            queryArguments.addAll(parameter.process(call));
        }
        call.setProcedureName(this.m_procedureName);
        call.setReturnsResultSet(this.m_returnsResultSet == null ? false : this.m_returnsResultSet);
        Map<String, Object> hints = this.processQueryHints(session);
        if (this.getResultClass() == Void.TYPE) {
            if (this.getResultSetMapping().equals("")) {
                session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(call, queryArguments, hints, loader));
            } else {
                session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(this.getResultSetMapping(), call, queryArguments, hints, loader));
            }
        } else {
            session.addQuery(this.getName(), EJBQueryImpl.buildStoredProcedureQuery(MetadataHelper.getClassForName(this.getResultClass().getName(), loader), call, queryArguments, hints, loader));
        }
    }

    public void setProcedureName(String procedureName) {
        this.m_procedureName = procedureName;
    }

    public void setParameters(List<StoredProcedureParameterMetadata> parameters) {
        this.m_parameters = parameters;
    }

    public void setReturnsResultSet(Boolean returnsResultSet) {
        this.m_returnsResultSet = returnsResultSet;
    }
}

