/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.InterfaceAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.DiscriminatorClassMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.DiscriminatorColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableOneToOneAccessor
extends ObjectAccessor {
    public static final String DEFAULT_QUERY_KEY = "id";
    private Integer m_lastDiscriminatorIndex;
    private DiscriminatorColumnMetadata m_discriminatorColumn;
    private List<DiscriminatorClassMetadata> m_discriminatorClasses = new ArrayList<DiscriminatorClassMetadata>();

    public VariableOneToOneAccessor() {
        super("<variable-one-to-one>");
    }

    public VariableOneToOneAccessor(Annotation variableOneToOne, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(variableOneToOne, accessibleObject, classAccessor);
        if (variableOneToOne != null) {
            this.setTargetEntity((Class)MetadataHelper.invokeMethod("targetInterface", variableOneToOne));
            this.m_discriminatorColumn = new DiscriminatorColumnMetadata((Annotation)MetadataHelper.invokeMethod("discriminatorColumn", variableOneToOne), accessibleObject);
            for (Annotation discriminatorClass : (Annotation[])MetadataHelper.invokeMethod("discriminatorClasses", variableOneToOne)) {
                this.m_discriminatorClasses.add(new DiscriminatorClassMetadata(discriminatorClass, accessibleObject));
            }
        }
    }

    public void addDiscriminatorClassFor(EntityAccessor accessor) {
        for (DiscriminatorClassMetadata discriminatorClass : this.m_discriminatorClasses) {
            if (!discriminatorClass.getValue().equals(accessor.getJavaClass())) continue;
            return;
        }
        VariableOneToOneMapping mapping = (VariableOneToOneMapping)this.getDescriptor().getMappingForAttributeName(this.getAttributeName());
        Class type = mapping.getTypeField().getType();
        if (type.equals(String.class)) {
            mapping.addClassNameIndicator(accessor.getJavaClassName(), accessor.getDescriptor().getAlias());
        } else if (type.equals(Character.class)) {
            mapping.addClassNameIndicator(accessor.getJavaClassName(), accessor.getJavaClassName().substring(0, 1));
        } else {
            if (this.m_lastDiscriminatorIndex == null) {
                for (String stringIndex : (List)mapping.getTypeIndicatorNameTranslation().values()) {
                    Integer index = new Integer(stringIndex);
                    if (this.m_lastDiscriminatorIndex != null && this.m_lastDiscriminatorIndex >= index) continue;
                    this.m_lastDiscriminatorIndex = index;
                }
            }
            this.m_lastDiscriminatorIndex = this.m_lastDiscriminatorIndex + 1;
            mapping.addClassNameIndicator(accessor.getJavaClassName(), this.m_lastDiscriminatorIndex);
        }
    }

    public List<DiscriminatorClassMetadata> getDiscriminatorClasses() {
        return this.m_discriminatorClasses;
    }

    public DiscriminatorColumnMetadata getDiscriminatorColumn() {
        return this.m_discriminatorColumn;
    }

    @Override
    protected String getLoggingContext() {
        return "metadata_default_variable_one_to_one_reference_class";
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        return this.getDescriptor();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.initXMLObject(this.m_discriminatorColumn, accessibleObject);
        this.initXMLObjects(this.m_discriminatorClasses, accessibleObject);
    }

    @Override
    public boolean isVariableOneToOne() {
        return true;
    }

    @Override
    public void process() {
        InterfaceAccessor interfaceAccessor = this.getProject().getInterfaceAccessor(this.getReferenceClassName());
        if (interfaceAccessor == null) {
            interfaceAccessor = new InterfaceAccessor(null, this.getReferenceClass(), this.getProject());
            interfaceAccessor.process();
            this.getProject().addInterfaceAccessor(interfaceAccessor);
        }
        interfaceAccessor.addVariableOneToOneAccessor(this);
        VariableOneToOneMapping mapping = new VariableOneToOneMapping();
        mapping.setIsReadOnly(false);
        mapping.setIsPrivateOwned(this.isPrivateOwned());
        mapping.setIsOptional(this.isOptional());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setReferenceClassName(this.getReferenceClassName());
        this.processIndirection(mapping);
        this.setAccessorMethods(mapping);
        this.processCascadeTypes(mapping);
        this.processReturnInsertAndUpdate();
        if (this.m_discriminatorColumn == null) {
            mapping.setTypeField(new DiscriminatorColumnMetadata().process(this.getDescriptor(), this.getAnnotatedElementName(), "metadata_default_variable_one_to_one_discriminator_column"));
        } else {
            mapping.setTypeField(this.m_discriminatorColumn.process(this.getDescriptor(), this.getAnnotatedElementName(), "metadata_default_variable_one_to_one_discriminator_column"));
        }
        for (DiscriminatorClassMetadata discriminatorClass : this.m_discriminatorClasses) {
            discriminatorClass.process(mapping);
        }
        this.processForeignQueryKeyNames(mapping);
        this.processProperties(mapping);
        this.getDescriptor().addMapping(mapping);
    }

    protected void processForeignQueryKeyNames(VariableOneToOneMapping mapping) {
        for (JoinColumnMetadata joinColumn : this.processJoinColumns()) {
            String queryKeyName = this.getName(joinColumn.getReferencedColumnName(), DEFAULT_QUERY_KEY, "metadata_default_qk_column");
            DatabaseField fkField = joinColumn.getForeignKeyField();
            fkField.setName(this.getName(fkField, this.getUpperCaseAttributeName() + "_ID", "metadata_default_fk_column"));
            if (fkField.getTableName().equals("")) {
                fkField.setTable(this.getDescriptor().getPrimaryTable());
            }
            mapping.addForeignQueryKeyName(fkField, queryKeyName);
            if (!fkField.isReadOnly()) continue;
            mapping.setIsReadOnly(true);
        }
    }

    public void setDiscriminatorClasses(List<DiscriminatorClassMetadata> discriminatorClasses) {
        this.m_discriminatorClasses = discriminatorClasses;
    }

    public void setDiscriminatorColumn(DiscriminatorColumnMetadata discriminatorColumn) {
        this.m_discriminatorColumn = discriminatorColumn;
    }
}

