/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.parameterParser;

import ecoSim.parameterParser.ParameterParserException;

abstract class AbstractParameterParser {
    AbstractParameterParser() {
    }

    protected static Number getNumber(String value) throws ParameterParserException {
        value = value.replace(',', '.');
        try {
            double n = Double.parseDouble(value);
            return AbstractParameterParser.getNumber(n);
        }
        catch (NumberFormatException ex) {
            throw new ParameterParserException("The value " + value + " is not a number");
        }
    }

    protected static Number getNumber(double n) {
        if (Math.floor(n) == n) {
            if (n >= -128.0 && n <= 127.0) {
                return new Byte((byte)n);
            }
            if (n >= -32768.0 && n <= 32767.0) {
                return new Short((short)n);
            }
            if (n >= -2.147483648E9 && n <= 2.147483647E9) {
                return new Integer((int)n);
            }
            if (n >= -9.223372036854776E18 && n <= 9.223372036854776E18) {
                return new Long((long)n);
            }
        } else if (n >= (double)1.4E-45f && n <= 3.4028234663852886E38) {
            return new Float((float)n);
        }
        return new Double(n);
    }
}

