/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui;

import ecoSim.DAOFacade;
import ecoSim.actions.AbstractEcoSimAction;
import ecoSim.data.DataBlockTableModel;
import ecoSim.entities.TableData;
import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.gui.CustomEcoSimGUI;
import java.util.HashMap;
import java.util.Map;
import org.gcn.plinguacore.util.Pair;

public class ManageRowsAction
extends AbstractEcoSimAction {
    private int index;
    private int rowAction = 1;
    private static Map<Pair<Integer, Integer>, ManageRowsAction> rowsActions = new HashMap<Pair<Integer, Integer>, ManageRowsAction>();

    private ManageRowsAction(Pair<Integer, Integer> dataBlockIndex) {
        this.index = (Integer)dataBlockIndex.getFirst();
        this.rowAction = (Integer)dataBlockIndex.getSecond();
    }

    @Override
    protected void doSecureAction(AbstractEcoSimGUI gui) {
        CustomEcoSimGUI cgui = (CustomEcoSimGUI)gui;
        DataBlockTableModel db = cgui.getData().getDataBlock(this.index);
        int currentRows = db.getRowCount();
        int currentColumns = db.getColumnCount();
        int newRows = 0;
        if (this.rowAction == 1) {
            newRows = currentRows + 1;
            System.out.println("Adding row...");
        } else if (this.rowAction == 2) {
            newRows = currentRows - 1;
            System.out.println("Deleting row...");
        }
        db.setSize(newRows, currentColumns);
        TableData td = DAOFacade.getTableById(this.index);
        td.getTableConfig().setNrows(newRows);
        DAOFacade.updateTable(td);
    }

    @Override
    public boolean isEnabledAction(AbstractEcoSimGUI gui) {
        return gui instanceof CustomEcoSimGUI && gui.getData().getState() != 4;
    }

    public static ManageRowsAction getInstance(int dataBlockIndex, int rowAction) {
        Pair pair = new Pair((Object)dataBlockIndex, (Object)rowAction);
        if (rowsActions.get(pair) == null) {
            rowsActions.put((Pair<Integer, Integer>)pair, new ManageRowsAction((Pair<Integer, Integer>)pair));
        }
        return rowsActions.get(pair);
    }
}

