/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class EcoSimFileFilter
extends FileFilter {
    public static final int TYPE_ECO = 1;
    public static final int TYPE_EC2 = 2;
    public static final int TYPE_BOTH = 3;
    public static final int TYPE_JPG = 4;
    public static final int TYPE_PNG = 5;
    private int type;
    private String[] ext;

    public EcoSimFileFilter(int type) {
        this.type = type;
        this.ext = new String[2];
        switch (type) {
            case 1: {
                this.ext[0] = ".eco";
                this.ext[1] = ".eco";
                break;
            }
            case 3: {
                this.ext[0] = ".eco";
                this.ext[1] = ".ec2";
                break;
            }
            case 2: {
                this.ext[0] = ".ec2";
                this.ext[1] = ".ec2";
                break;
            }
            case 4: {
                this.ext[0] = ".jpg";
                this.ext[1] = ".jpg";
                break;
            }
            case 5: {
                this.ext[0] = ".png";
                this.ext[1] = ".png";
            }
        }
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (file.getName().length() < 5) {
            return false;
        }
        int n1 = file.getName().lastIndexOf(this.ext[0]);
        int n2 = file.getName().lastIndexOf(this.ext[1]);
        return n1 == file.getName().length() - 4 || n2 == file.getName().length() - 4;
    }

    @Override
    public String getDescription() {
        if (this.type == 3) {
            return "Scenario files (*.eco, *.ec2)";
        }
        if (this.type == 2) {
            return "Scenario files (*.ec2)";
        }
        if (this.type == 4) {
            return "Image files (*.jpg)";
        }
        if (this.type == 5) {
            return "Image files (*.png)";
        }
        return "Scenario files (*.eco)";
    }

    public File completeExtension(File file) {
        if (this.type == 3) {
            return file;
        }
        String path = file.getAbsolutePath();
        String semipath = path.lastIndexOf(".") < 0 ? path : path.substring(0, path.lastIndexOf("."));
        if (this.type == 1) {
            path = String.valueOf(semipath) + ".eco";
        } else if (this.type == 2) {
            path = String.valueOf(semipath) + ".ec2";
        } else if (this.type == 4) {
            path = String.valueOf(semipath) + ".jpg";
        } else if (this.type == 5) {
            path = String.valueOf(semipath) + ".png";
        }
        return new File(path);
    }
}

