/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui;

import ecoSim.gui.AbstractEcoSimGUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public abstract class AbstractEcoSimView {
    private String name;
    private AbstractEcoSimGUI gui;
    private List<AbstractEcoSimView> buttons;
    private JComponent view = null;
    private boolean border = false;
    private String text = null;

    public AbstractEcoSimView(String name, boolean border, AbstractEcoSimGUI gui) {
        if (name == null || gui == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.gui = gui;
        this.border = border;
        this.buttons = new ArrayList<AbstractEcoSimView>();
    }

    public final String getText() {
        return this.text;
    }

    protected final void setText(String text) {
        this.text = text;
    }

    public final String getName() {
        return this.name;
    }

    public final AbstractEcoSimGUI getGUI() {
        return this.gui;
    }

    public final boolean isBorder() {
        return this.border;
    }

    public final List<AbstractEcoSimView> getButtons() {
        return this.buttons;
    }

    private JPanel createButtons() {
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPane.add(Box.createHorizontalGlue());
        ListIterator<AbstractEcoSimView> it = this.buttons.listIterator();
        while (it.hasNext()) {
            buttonPane.add(it.next().getView());
            buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        if (this.text != null) {
            buttonPane.add((Component)new JLabel(this.text), 0);
        }
        return buttonPane;
    }

    public final void paintView() {
        this.view = this.createSpecificView();
        if (!this.buttons.isEmpty() || this.text != null) {
            JPanel p = new JPanel();
            BorderLayout thisLayout = new BorderLayout();
            p.setLayout(thisLayout);
            p.add((Component)this.view, "Center");
            p.add((Component)this.createButtons(), "South");
            this.view = p;
        }
        if (this.border) {
            this.view.setBorder(new TitledBorder(this.name));
        }
    }

    public final JComponent getView() {
        if (this.view == null) {
            this.paintView();
        }
        return this.view;
    }

    protected abstract JComponent createSpecificView();

    public String toString() {
        return this.name;
    }
}

