/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui;

import ecoSim.SelectApplicationFrm;
import ecoSim.data.AbstractEcoSimData;
import ecoSim.gui.AbstractEcoSimView;
import ecoSim.gui.ConsolePrintStream;
import ecoSim.gui.swing.JLabelListener;
import ecoSim.gui.swing.JMenuListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public abstract class AbstractEcoSimGUI {
    private String title = "";
    private AbstractEcoSimView body = null;
    private AbstractEcoSimData data;
    private JFrame frame = null;
    private Component focusComponent;
    private Map<String, ConsolePrintStream> printStreams;
    private JProgressBar bar;
    private boolean asEndUser;

    public boolean isAsEndUser() {
        return this.asEndUser;
    }

    public AbstractEcoSimGUI(AbstractEcoSimData data, boolean asEndUser) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = data;
        this.printStreams = new HashMap<String, ConsolePrintStream>();
        String titleAux = data.getApplicationName();
        if (data.getApplicationVersion() != null && !data.getApplicationVersion().equals("Release")) {
            titleAux = String.valueOf(titleAux) + " [" + data.getApplicationVersion() + "]";
        }
        this.setTitle(titleAux);
        data.loadCnfFile();
        this.asEndUser = asEndUser;
        if (data.getDataFile() == null) {
            data.reset();
        }
    }

    public JProgressBar getBar() {
        return this.bar;
    }

    public Map<String, ConsolePrintStream> getPrintStreams() {
        return this.printStreams;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setFrame(JFrame frame) {
        this.frame = frame;
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    protected void setBody(AbstractEcoSimView body) {
        this.body = body;
    }

    public AbstractEcoSimData getData() {
        return this.data;
    }

    public Component getFocusComponent() {
        return this.focusComponent;
    }

    public void setFocusComponent(Component focusComponent) {
        if (this.focusComponent != focusComponent) {
            this.focusComponent = focusComponent;
        }
    }

    public void enableView() {
        if (this.frame != null) {
            return;
        }
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setTitle(AbstractEcoSimGUI.this.title);
                BorderLayout thisLayout = new BorderLayout();
                frame.getContentPane().setLayout(thisLayout);
                frame.getContentPane().add((Component)AbstractEcoSimGUI.this.body.getView(), "Center");
                if (AbstractEcoSimGUI.this.asEndUser) {
                    frame.setDefaultCloseOperation(3);
                } else {
                    frame.setDefaultCloseOperation(2);
                }
                this.setClosingOperation(frame);
                JLabelListener label = new JLabelListener(AbstractEcoSimGUI.this.data);
                AbstractEcoSimGUI.this.data.addListener(label);
                JPanel southPane = new JPanel();
                southPane.setLayout(new BorderLayout());
                southPane.add((Component)label, "North");
                AbstractEcoSimGUI.this.bar = new JProgressBar();
                AbstractEcoSimGUI.this.bar.setStringPainted(true);
                AbstractEcoSimGUI.this.bar.setToolTipText("Simulation Progress");
                southPane.add((Component)AbstractEcoSimGUI.this.bar, "Center");
                JLabel label2 = new JLabel("(c) 2011 Research Group on Natural Computing. http://www.gcn.us.es");
                southPane.add((Component)label2, "South");
                frame.getContentPane().add((Component)southPane, "South");
                frame.setSize(800, 600);
                frame.setLocationRelativeTo(null);
                JMenuListener menuListener = AbstractEcoSimGUI.this.getJMenuListener();
                AbstractEcoSimGUI.this.data.addListener(menuListener);
                frame.setJMenuBar(menuListener.getjMenu());
                frame.setVisible(true);
                AbstractEcoSimGUI.this.setFrame(frame);
            }

            private void setClosingOperation(JFrame frame) {
                frame.addWindowListener(new WindowListener(){

                    @Override
                    public void windowOpened(WindowEvent arg0) {
                    }

                    @Override
                    public void windowIconified(WindowEvent arg0) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent arg0) {
                    }

                    @Override
                    public void windowDeactivated(WindowEvent arg0) {
                        SelectApplicationFrm.generalFrame.setEnabled(true);
                    }

                    @Override
                    public void windowClosing(WindowEvent arg0) {
                    }

                    @Override
                    public void windowClosed(WindowEvent arg0) {
                        SelectApplicationFrm.generalFrame.setEnabled(true);
                    }

                    @Override
                    public void windowActivated(WindowEvent arg0) {
                    }
                });
            }
        });
    }

    public abstract void showOutput();

    private JMenuListener getJMenuListener() {
        return new JMenuListener(this);
    }
}

