/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.factory;

import java.util.LinkedHashSet;
import org.gcn.plinguacore.util.Pair;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

public class CustomMultiLineChart {
    private String name;
    private String[][] resultTable;
    private String group;
    private String subgroup;
    private String part;
    private String dataName;
    int categoryIndex = 0;
    int subCategoryIndex = 1;
    int seriesIndex = 2;
    int dataIndex = 3;

    public CustomMultiLineChart() {
    }

    public CustomMultiLineChart(String name, String[][] resultTable, String group, String subgroup, String part, String dataName, int categoryIndex, int subCategoryIndex, int seriesIndex, int dataIndex) {
        this.name = name;
        this.resultTable = resultTable;
        this.group = group;
        this.subgroup = subgroup;
        this.part = part;
        this.dataName = dataName;
        this.categoryIndex = categoryIndex;
        this.subCategoryIndex = subCategoryIndex;
        this.seriesIndex = seriesIndex;
        this.dataIndex = dataIndex;
    }

    public LinkedHashSet<Pair<JFreeChart, String>> showGraphs(boolean makeVisible) {
        LinkedHashSet<Pair<JFreeChart, String>> charts = new LinkedHashSet<Pair<JFreeChart, String>>();
        if (this.resultTable != null && this.resultTable[0] != null && this.resultTable[0].length == 4) {
            String domain = "";
            String range = "";
            domain = String.valueOf(this.group) + " / " + this.part;
            range = this.dataName;
            LinkedHashSet<String> parts = new LinkedHashSet<String>();
            int n = 0;
            while (n < this.resultTable.length) {
                parts.add(this.resultTable[n][this.subCategoryIndex]);
                ++n;
            }
            for (String partName : parts) {
                charts.add((Pair<JFreeChart, String>)new Pair((Object)this.showGraph(false, partName, domain, range), (Object)(String.valueOf(this.subgroup) + " " + partName)));
            }
        }
        return charts;
    }

    private JFreeChart showGraph(boolean makeVisible, String partName, String domain, String range) {
        JFreeChart chart = null;
        if (this.resultTable != null) {
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            int i = 0;
            while (i < this.resultTable.length) {
                if (this.resultTable[i][this.subCategoryIndex].equals(partName)) {
                    dataset.addValue(Double.parseDouble(this.resultTable[i][this.dataIndex]), (Comparable)((Object)this.resultTable[i][this.seriesIndex]), (Comparable)((Object)this.resultTable[i][this.categoryIndex]));
                }
                ++i;
            }
            chart = ChartFactory.createLineChart(this.name.concat(" Line Chart"), domain, range, dataset, PlotOrientation.VERTICAL, true, true, false);
            if (makeVisible) {
                ChartFrame frame = new ChartFrame(this.name, chart);
                frame.pack();
                frame.setVisible(true);
            }
        }
        return chart;
    }
}

