/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.data;

import ecoSim.DAOFacade;
import ecoSim.data.AbstractEcoSimCnfData;
import ecoSim.data.DataBlockTableModel;
import ecoSim.data.OutputDataBlockTableModel;
import ecoSim.entities.TableData;
import ecoSim.factory.CustomDataBlock;
import ecoSim.factory.IParametersStrategy;
import ecoSim.gui.ConsolePrintStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JProgressBar;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class AbstractEcoSimData
extends AbstractEcoSimCnfData
implements Serializable,
TableModelListener {
    private static final long serialVersionUID = 7473214100259521736L;
    private Map<Integer, DataBlockTableModel> dataBlocks = new HashMap<Integer, DataBlockTableModel>();
    private transient Map<Integer, OutputDataBlockTableModel> outputDataBlocks = new HashMap<Integer, OutputDataBlockTableModel>();

    public AbstractEcoSimData(String factoryName, int applicationID, String applicationName, String applicationVersion, String mode) {
        super(factoryName, applicationID, applicationName, applicationVersion);
    }

    public void clear() {
        Iterator<Integer> it = this.dataBlocks.keySet().iterator();
        while (it.hasNext()) {
            this.dataBlocks.get(it.next()).clear();
        }
        Iterator<Integer> it1 = this.outputDataBlocks.keySet().iterator();
        while (it1.hasNext()) {
            this.outputDataBlocks.get(it1.next()).clear();
        }
        this.setDataFile(null);
        this.setState(0);
    }

    public OutputDataBlockTableModel getOutputDataBlock(int blockIndex) {
        return this.outputDataBlocks.get(blockIndex);
    }

    public int outputDataBlockCount() {
        return this.outputDataBlocks.keySet().size();
    }

    public DataBlockTableModel getDataBlock(int blockIndex) {
        return this.dataBlocks.get(blockIndex);
    }

    public int dataBlockCount() {
        return this.dataBlocks.keySet().size();
    }

    public Integer[] dataBlockIndexes() {
        Integer[] r = new Integer[this.dataBlockCount()];
        this.dataBlocks.keySet().toArray(r);
        return r;
    }

    public Integer[] outputDataBlockIndexes() {
        Integer[] r = new Integer[this.outputDataBlockCount()];
        this.outputDataBlocks.keySet().toArray(r);
        return r;
    }

    protected void addDataBlock(int index, DataBlockTableModel dataBlock) {
        this.dataBlocks.put(index, dataBlock);
    }

    protected void addOutputDataBlock(int index, OutputDataBlockTableModel dataBlock) {
        this.outputDataBlocks.put(index, dataBlock);
    }

    protected abstract boolean loadEcoFile(File var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean load(File file) {
        if (file.getName().indexOf(".eco") != -1) {
            return this.loadEcoFile(file);
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            try {
                ObjectInputStream stream = new ObjectInputStream(inputStream);
                try {
                    Object obj = stream.readObject();
                    stream.close();
                    if (!(obj instanceof AbstractEcoSimData)) {
                        return false;
                    }
                    AbstractEcoSimData data = (AbstractEcoSimData)obj;
                    for (Integer id : this.dataBlocks.keySet()) {
                        if (!data.dataBlocks.containsKey(id)) continue;
                        DataBlockTableModel src = data.dataBlocks.get(id);
                        DataBlockTableModel dst = this.dataBlocks.get(id);
                        int loadedRows = src.getRowCount();
                        int loadedCols = src.getColumnCount();
                        dst.setSize(loadedRows, loadedCols);
                        int i = 0;
                        while (i < dst.getRowCount()) {
                            int j = 0;
                            while (j < dst.getColumnCount()) {
                                if (i < loadedRows && j < loadedCols) {
                                    dst.updateValue(src.getValueAt(i, j), i, j);
                                }
                                ++j;
                            }
                            ++i;
                        }
                        TableData td = DAOFacade.getTableById(id);
                        td.getTableConfig().setNrows(src.getRowCount());
                        DAOFacade.updateTable(td);
                        if (dst instanceof CustomDataBlock) {
                            CustomDataBlock cdst = (CustomDataBlock)dst;
                            cdst.getTableData().getTableConfig().setNrows(loadedRows);
                            cdst.getTableData().getTableConfig().setNcols(loadedCols);
                        }
                        dst.update(true);
                        dst.notifyListeners();
                    }
                    this.setDataFile(file);
                    this.setSimulator(null);
                    this.setState(2);
                    return true;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean save(File file, boolean validateAppId) {
        if (validateAppId) {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                try {
                    ObjectInputStream stream = new ObjectInputStream(inputStream);
                    try {
                        Object obj = stream.readObject();
                        stream.close();
                        if (!(obj instanceof AbstractEcoSimData)) {
                            return false;
                        }
                        AbstractEcoSimData data = (AbstractEcoSimData)obj;
                        if (data.getApplicationID() != this.getApplicationID()) {
                            return false;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        return false;
                    }
                }
                catch (IOException e) {
                    return false;
                }
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }
        try {
            FileOutputStream fileStream = new FileOutputStream(file);
            try {
                ObjectOutputStream objectStream = new ObjectOutputStream(fileStream);
                objectStream.writeObject(this);
                objectStream.close();
                this.setDataFile(file);
                this.setState(2);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    @Override
    public void tableChanged(TableModelEvent arg0) {
        if (this.getState() != 3) {
            if (this.isUserMode() && this.getState() == 1) {
                this.setDataFile(null);
            }
            this.setState(3);
        }
    }

    public void readPLinguaFile(ConsolePrintStream error, ConsolePrintStream warning, ConsolePrintStream info, IParametersStrategy strategy, int verbosity, JProgressBar bar, String algorithm) {
        this.getProxySimulator().getSimulator(this, error, warning, info, strategy, verbosity, bar, algorithm);
    }
}

