/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.actions;

import ecoSim.actions.AbstractEcoSimAction;
import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.gui.EcoSimFileFilter;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class EcoSimSaveAsAction
extends AbstractEcoSimAction {
    private static EcoSimSaveAsAction singleton = null;

    private EcoSimSaveAsAction() {
    }

    protected static void save(AbstractEcoSimGUI gui, File f, boolean validateAppId) {
        if (!gui.getData().save(f, validateAppId)) {
            String messageText = "Unable to save!\n\n";
            messageText = String.valueOf(messageText) + "Probably the Application Id of the running simulator\n";
            messageText = String.valueOf(messageText) + "is different from the Application Id of the scenario file.\n\n";
            messageText = String.valueOf(messageText) + "For security reasons this is forbidden,\n";
            messageText = String.valueOf(messageText) + "because this file could belong to another custom simulator.\n\n";
            messageText = String.valueOf(messageText) + "Please try 'Save As...' option and save the current data in a new file.\n";
            JOptionPane.showMessageDialog(gui.getFrame(), messageText, "Error", 0);
        }
    }

    @Override
    protected void doSecureAction(AbstractEcoSimGUI gui) {
        JFileChooser chooser = new JFileChooser();
        EcoSimFileFilter filter = new EcoSimFileFilter(2);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(gui.getFrame());
        if (returnVal == 0) {
            File f = filter.completeExtension(chooser.getSelectedFile());
            boolean validateAppId = false;
            if (f.exists()) {
                validateAppId = true;
                String messageText = "Are you sure you want to update the selected scenario file?\n";
                int opt = JOptionPane.showConfirmDialog(null, messageText = String.valueOf(messageText) + "Any information previously contained in the file will be lost.", "Update Config confirmation", 0);
                if (opt == 0) {
                    EcoSimSaveAsAction.save(gui, f, validateAppId);
                }
            } else {
                EcoSimSaveAsAction.save(gui, f, validateAppId);
            }
        }
    }

    public static EcoSimSaveAsAction getInstance() {
        if (singleton == null) {
            singleton = new EcoSimSaveAsAction();
        }
        return singleton;
    }

    @Override
    public boolean isEnabledAction(AbstractEcoSimGUI gui) {
        return gui.getData().getState() != 4;
    }
}

