/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.actions;

import ecoSim.actions.AbstractEcoSimAction;
import ecoSim.gui.AbstractEcoSimGUI;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class EcoSimCopyAction
extends AbstractEcoSimAction {
    private static EcoSimCopyAction singleton = null;

    private EcoSimCopyAction() {
    }

    private String objectToString(Object o) {
        String str = o.toString();
        if (o instanceof Number && str.length() > 2) {
            if (str.substring(str.length() - 2).equals(".0")) {
                str = str.substring(0, str.length() - 2);
            }
            str = str.replace('.', ',');
        }
        return str;
    }

    @Override
    protected void doSecureAction(AbstractEcoSimGUI gui) {
        Component c = gui.getFocusComponent();
        if (c != null && c instanceof JTable) {
            JTable t = (JTable)c;
            StringBuffer sbf = new StringBuffer();
            int i = 0;
            while (i < t.getSelectedRowCount()) {
                int x = t.getSelectedRows()[i];
                int j = 0;
                while (j < t.getSelectedColumnCount()) {
                    int y = t.getSelectedColumns()[j];
                    Object o = t.getModel().getValueAt(x, y);
                    if (o != null) {
                        sbf.append(this.objectToString(o));
                    } else {
                        sbf.append("\t");
                    }
                    if (j < t.getSelectedColumnCount() - 1) {
                        int z = t.getSelectedColumns()[j + 1];
                        int k = y;
                        while (k < z) {
                            sbf.append("\t");
                            ++k;
                        }
                    }
                    ++j;
                }
                if (i < t.getSelectedRowCount() - 1) {
                    int z = t.getSelectedRows()[i + 1];
                    int k = x;
                    while (k < z) {
                        sbf.append("\n");
                        ++k;
                    }
                }
                ++i;
            }
            StringSelection stsel = new StringSelection(sbf.toString());
            Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
            system.setContents(stsel, stsel);
        } else if (c != null && c instanceof JTextArea) {
            JTextArea t = (JTextArea)c;
            StringBuffer sbf = new StringBuffer();
            String str = t.getSelectedText();
            if (str != null) {
                sbf.append(str);
                StringSelection stsel = new StringSelection(sbf.toString());
                Clipboard system = Toolkit.getDefaultToolkit().getSystemClipboard();
                system.setContents(stsel, stsel);
            }
        }
    }

    public static EcoSimCopyAction getInstance() {
        if (singleton == null) {
            singleton = new EcoSimCopyAction();
        }
        return singleton;
    }

    @Override
    public boolean isEnabledAction(AbstractEcoSimGUI gui) {
        return gui.getData().getState() != 4;
    }
}

