/*
 * Decompiled with CFR 0.152.
 */
package ecoSim;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zip {
    static final int BUFFER = 1024;

    public static void main(String[] argv) {
    }

    public static void makeZip(String fileName, Set<String> excludeFiles) throws IOException, FileNotFoundException {
        File file = new File(fileName);
        Zip.makeZip(fileName, excludeFiles, file.getName());
    }

    public static void makeZip(String fileName, Set<String> excludeFiles, String zipName) throws IOException, FileNotFoundException {
        if (excludeFiles == null) {
            excludeFiles = new HashSet<String>();
        }
        File file = new File(fileName);
        try {
            System.out.println("Origin file: " + file.getAbsolutePath());
            String outputZipFile = String.valueOf(file.getParent()) + "/" + zipName + ".zip";
            FileOutputStream dest = new FileOutputStream(outputZipFile);
            CheckedOutputStream checksum = new CheckedOutputStream(dest, new Adler32());
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(checksum));
            String entryName = String.valueOf(zipName) + "/";
            ZipEntry entry = new ZipEntry(entryName);
            out.putNextEntry(entry);
            out.closeEntry();
            Zip.recursiveZipping(fileName, entryName, out, excludeFiles);
            out.close();
            System.out.println("checksum: " + checksum.getChecksum().getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void makeZip(String fileName) throws IOException, FileNotFoundException {
        Zip.makeZip(fileName, new HashSet<String>());
    }

    private static void recursiveZipping(String fileName, String relativePath, ZipOutputStream out, Set<String> excludeFiles) {
        File file = new File(fileName);
        byte[] data = new byte[1024];
        File f = file;
        BufferedInputStream origin = null;
        String[] files = f.list();
        try {
            if (files != null && files.length != 0) {
                int i = 0;
                while (i < files.length) {
                    System.out.println("Adding: " + files[i]);
                    File fIn = new File(String.valueOf(fileName) + "/" + files[i]);
                    if (!fIn.isDirectory()) {
                        if (!excludeFiles.contains(fIn.getName())) {
                            int count;
                            FileInputStream fi = new FileInputStream(fIn);
                            origin = new BufferedInputStream(fi, 1024);
                            ZipEntry entry = new ZipEntry(String.valueOf(relativePath) + files[i]);
                            out.putNextEntry(entry);
                            while ((count = origin.read(data, 0, 1024)) != -1) {
                                out.write(data, 0, count);
                            }
                            origin.close();
                        }
                    } else {
                        System.out.println("Path: " + fIn.getAbsolutePath());
                        Zip.recursiveZipping(fIn.getAbsolutePath(), String.valueOf(relativePath) + fIn.getName() + "/", out, excludeFiles);
                    }
                    ++i;
                }
            } else {
                String folderPath = relativePath;
                if (folderPath != null && folderPath.length() > 1) {
                    ZipEntry entry = new ZipEntry(folderPath);
                    out.putNextEntry(entry);
                    out.closeEntry();
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

