/*
 * Decompiled with CFR 0.152.
 */
package ecoSim;

import ecoSim.DAOFacade;
import ecoSim.SelectApplicationFrm;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.dyno.visual.swing.layouts.Constraints;
import org.dyno.visual.swing.layouts.GroupLayout;
import org.dyno.visual.swing.layouts.Leading;

public class LoadConfigFileDlg
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JRadioButton updateTabsRad;
    private ButtonGroup selectedFileInfoGrp;
    private JRadioButton updateAllRad;
    private JLabel selectedFileInfoLbl;
    private JTextArea selectedFileInfoTxa;
    private JScrollPane jScrollPane0;
    private JLabel loadOptionsLbl;
    private File innerFile;
    private JButton updateConfigBtn;
    private SelectApplicationFrm parentFrame;
    private static final String PREFERRED_LOOK_AND_FEEL = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";

    public LoadConfigFileDlg() {
        this.initComponents();
    }

    public LoadConfigFileDlg(File f, SelectApplicationFrm frame) {
        this.initComponents();
        this.innerFile = f;
        this.parentFrame = frame;
    }

    public LoadConfigFileDlg(Frame parent) {
        super(parent);
        this.initComponents();
    }

    public LoadConfigFileDlg(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public LoadConfigFileDlg(Frame parent, String title) {
        super(parent, title);
        this.initComponents();
    }

    public LoadConfigFileDlg(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.initComponents();
    }

    public LoadConfigFileDlg(Frame parent, String title, boolean modal, GraphicsConfiguration arg) {
        super(parent, title, modal, arg);
        this.initComponents();
    }

    public LoadConfigFileDlg(Dialog parent) {
        super(parent);
        this.initComponents();
    }

    public LoadConfigFileDlg(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public LoadConfigFileDlg(Dialog parent, String title) {
        super(parent, title);
        this.initComponents();
    }

    public LoadConfigFileDlg(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        this.initComponents();
    }

    public LoadConfigFileDlg(Dialog parent, String title, boolean modal, GraphicsConfiguration arg) {
        super(parent, title, modal, arg);
        this.initComponents();
    }

    public LoadConfigFileDlg(Window parent) {
        super(parent);
        this.initComponents();
    }

    public LoadConfigFileDlg(Window parent, Dialog.ModalityType modalityType) {
        super(parent, modalityType);
        this.initComponents();
    }

    public LoadConfigFileDlg(Window parent, String title) {
        super(parent, title);
        this.initComponents();
    }

    public LoadConfigFileDlg(Window parent, String title, Dialog.ModalityType modalityType) {
        super(parent, title, modalityType);
        this.initComponents();
    }

    public LoadConfigFileDlg(Window parent, String title, Dialog.ModalityType modalityType, GraphicsConfiguration arg) {
        super(parent, title, modalityType, arg);
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle("Load Configuration File");
        this.setFont(new Font("Dialog", 0, 12));
        this.setBackground(Color.white);
        this.setResizable(false);
        this.setForeground(Color.black);
        this.setLayout(new GroupLayout());
        this.add((Component)this.getSelectedFileInfoLbl(), new Constraints(new Leading(39, 12, 12), new Leading(20, 12, 12)));
        this.add((Component)this.getUpdateConfigBtn(), new Constraints(new Leading(266, 10, 10), new Leading(262, 10, 10)));
        this.add((Component)this.getLoadOptionsLbl(), new Constraints(new Leading(42, 185, 10, 10), new Leading(146, 10, 10)));
        this.add((Component)this.getUpdateTabsRad(), new Constraints(new Leading(60, 6, 6), new Leading(214, 10, 10)));
        this.add((Component)this.getUpdateAllRad(), new Constraints(new Leading(62, 275, 10, 10), new Leading(177, 6, 6)));
        this.add((Component)this.getJScrollPane0(), new Constraints(new Leading(61, 338, 6, 6), new Leading(55, 66, 10, 10)));
        this.initSelectedFileInfoGrp();
        this.setSize(460, 325);
    }

    private JButton getUpdateConfigBtn() {
        if (this.updateConfigBtn == null) {
            this.updateConfigBtn = new JButton();
            this.updateConfigBtn.setText("Update config info");
            this.updateConfigBtn.addActionListener(this);
        }
        return this.updateConfigBtn;
    }

    private void initSelectedFileInfoGrp() {
        this.selectedFileInfoGrp = new ButtonGroup();
        this.selectedFileInfoGrp.add(this.getUpdateAllRad());
        this.selectedFileInfoGrp.add(this.getUpdateTabsRad());
        this.selectedFileInfoGrp.setSelected(this.updateAllRad.getModel(), true);
    }

    private JLabel getSelectedFileInfoLbl() {
        if (this.selectedFileInfoLbl == null) {
            this.selectedFileInfoLbl = new JLabel();
            this.selectedFileInfoLbl.setForeground(Color.blue);
            this.selectedFileInfoLbl.setText("Selected file information:");
        }
        return this.selectedFileInfoLbl;
    }

    private JScrollPane getJScrollPane0() {
        if (this.jScrollPane0 == null) {
            this.jScrollPane0 = new JScrollPane();
            this.jScrollPane0.setViewportView(this.getJTextArea0());
        }
        return this.jScrollPane0;
    }

    private JTextArea getJTextArea0() {
        if (this.selectedFileInfoTxa == null) {
            this.selectedFileInfoTxa = new JTextArea();
            this.selectedFileInfoTxa.setEditable(false);
        }
        return this.selectedFileInfoTxa;
    }

    private JLabel getLoadOptionsLbl() {
        if (this.loadOptionsLbl == null) {
            this.loadOptionsLbl = new JLabel();
            this.loadOptionsLbl.setForeground(Color.blue);
            this.loadOptionsLbl.setText("Load information options:");
        }
        return this.loadOptionsLbl;
    }

    private JRadioButton getUpdateAllRad() {
        if (this.updateAllRad == null) {
            this.updateAllRad = new JRadioButton();
            this.updateAllRad.setText("Update all information");
            this.updateAllRad.setActionCommand("UpdateAll");
        }
        return this.updateAllRad;
    }

    private JRadioButton getUpdateTabsRad() {
        if (this.updateTabsRad == null) {
            this.updateTabsRad = new JRadioButton();
            this.updateTabsRad.setSelected(true);
            this.updateTabsRad.setText("Update tabs, tables and outputs information");
            this.updateTabsRad.setActionCommand("UpdateTables");
        }
        return this.updateTabsRad;
    }

    private static void installLnF() {
        try {
            String lnfClassname = PREFERRED_LOOK_AND_FEEL;
            if (lnfClassname == null) {
                lnfClassname = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(lnfClassname);
        }
        catch (Exception e) {
            System.err.println("Cannot install com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel on this platform:" + e.getMessage());
        }
    }

    public static void main(String[] args) {
        LoadConfigFileDlg.installLnF();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoadConfigFileDlg dialog = new LoadConfigFileDlg();
                dialog.setDefaultCloseOperation(2);
                dialog.setLocationRelativeTo(null);
                dialog.getContentPane().setPreferredSize(dialog.getSize());
                dialog.pack();
                dialog.setVisible(true);
            }
        });
    }

    public void loadInfo() {
        LoadConfigFileDlg.installLnF();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.getContentPane().setPreferredSize(this.getSize());
        this.selectedFileInfoTxa.setText("Path: " + this.innerFile.getAbsolutePath());
        this.selectedFileInfoTxa.setText(String.valueOf(this.selectedFileInfoTxa.getText()) + "\nThis file will be loaded by pressing the button below");
        DAOFacade.setConfigFile(this.innerFile.getAbsolutePath());
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int id = DAOFacade.getAppIdFromExcel();
        String string1 = "Yes";
        String string2 = "No";
        Object[] options = new Object[]{string1, string2};
        int opt = JOptionPane.showConfirmDialog(this, "Are you sure you want to update the information in the application with id " + id + "? ", "Update Config confirmation", 0);
        if (opt == 0) {
            String command = this.selectedFileInfoGrp.getSelection().getActionCommand();
            if (command.equals("UpdateAll")) {
                DAOFacade.updateModelFromExcel(true, true, true, true, true, true);
            } else if (command.equals("UpdateTables")) {
                DAOFacade.updateModelFromExcel(true, false, true, true, true, true);
            }
            this.parentFrame.reloadApps();
            this.dispose();
        } else {
            this.dispose();
        }
    }
}

