/*
 * Decompiled with CFR 0.152.
 */
package ecoSim;

import ecoSim.DAOFacade;
import ecoSim.gui.swing.CheckListItem;
import ecoSim.gui.swing.CheckListRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.dyno.visual.swing.layouts.Constraints;
import org.dyno.visual.swing.layouts.GroupLayout;
import org.dyno.visual.swing.layouts.Leading;

public class ExportAppDlg
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton exportAppBtn;
    int appId;
    private JRadioButton endUserRad;
    private JRadioButton designerRad;
    private JLabel userTypeLbl;
    private JList pluginJarsList;
    private JScrollPane pluginJarsToIncludeSPn;
    private JLabel pluginJarsToIncludeLbl;
    private ButtonGroup userTypeGrp;
    private JList pluginsToIncludeList;
    private JScrollPane pluginsToIncludeSPn;
    private JLabel pluginsToIncludeLbl;
    private static final String PREFERRED_LOOK_AND_FEEL = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
    private Set<String> selectedPlugins = new HashSet<String>();

    public ExportAppDlg() {
        this.initComponents();
    }

    public ExportAppDlg(Frame parent) {
        super(parent);
        this.initComponents();
    }

    public ExportAppDlg(Frame parent, int appId) {
        super(parent);
        this.initComponents();
        this.appId = appId;
    }

    public ExportAppDlg(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public ExportAppDlg(Frame parent, String title) {
        super(parent, title);
        this.initComponents();
    }

    public ExportAppDlg(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.initComponents();
    }

    public ExportAppDlg(Frame parent, String title, boolean modal, GraphicsConfiguration arg) {
        super(parent, title, modal, arg);
        this.initComponents();
    }

    public ExportAppDlg(Dialog parent) {
        super(parent);
        this.initComponents();
    }

    public ExportAppDlg(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public ExportAppDlg(Dialog parent, String title) {
        super(parent, title);
        this.initComponents();
    }

    public ExportAppDlg(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        this.initComponents();
    }

    public ExportAppDlg(Dialog parent, String title, boolean modal, GraphicsConfiguration arg) {
        super(parent, title, modal, arg);
        this.initComponents();
    }

    public ExportAppDlg(Window parent) {
        super(parent);
        this.initComponents();
    }

    public ExportAppDlg(Window parent, Dialog.ModalityType modalityType) {
        super(parent, modalityType);
        this.initComponents();
    }

    public ExportAppDlg(Window parent, String title) {
        super(parent, title);
        this.initComponents();
    }

    public ExportAppDlg(Window parent, String title, Dialog.ModalityType modalityType) {
        super(parent, title, modalityType);
        this.initComponents();
    }

    public ExportAppDlg(Window parent, String title, Dialog.ModalityType modalityType, GraphicsConfiguration arg) {
        super(parent, title, modalityType, arg);
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle("Export Custom App");
        this.setFont(new Font("Dialog", 0, 12));
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setLayout(new GroupLayout());
        this.add((Component)this.getExportAppBtn(), new Constraints(new Leading(475, 10, 10), new Leading(182, 10, 10)));
        this.add((Component)this.getUserTypeLbl(), new Constraints(new Leading(473, 10, 10), new Leading(72, 10, 10)));
        this.add((Component)this.getDesignerRad(), new Constraints(new Leading(475, 88, 10, 10), new Leading(121, 10, 10)));
        this.add((Component)this.getEndUserRad(), new Constraints(new Leading(475, 88, 10, 10), new Leading(98, 12, 12)));
        this.add((Component)this.getPluginsListSPn(), new Constraints(new Leading(18, 187, 10, 10), new Leading(52, 122, 12, 12)));
        this.add((Component)this.getPluginsLbl(), new Constraints(new Leading(21, 10, 10), new Leading(24, 12, 12)));
        this.add((Component)this.getPluginJarsToIncludeSPn(), new Constraints(new Leading(243, 196, 10, 10), new Leading(52, 122, 6, 6)));
        this.add((Component)this.getPluginJarsToIncludeLbl(), new Constraints(new Leading(246, 10, 10), new Leading(24, 12, 12)));
        this.initUserTypeGrp();
        this.setSize(632, 228);
    }

    private JLabel getPluginsLbl() {
        if (this.pluginsToIncludeLbl == null) {
            this.pluginsToIncludeLbl = new JLabel("Select the plugins to include");
        }
        return this.pluginsToIncludeLbl;
    }

    private JScrollPane getPluginsListSPn() {
        if (this.pluginsToIncludeSPn == null) {
            this.pluginsToIncludeSPn = new JScrollPane();
            this.pluginsToIncludeSPn.setViewportView(this.getPluginsList());
        }
        return this.pluginsToIncludeSPn;
    }

    private JList getPluginsList() {
        if (this.pluginsToIncludeList == null) {
            this.pluginsToIncludeList = new JList<CheckListItem>(this.getPluginItems());
            this.pluginsToIncludeList.setCellRenderer(new CheckListRenderer());
            this.pluginsToIncludeList.setSelectionMode(2);
            this.pluginsToIncludeList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    CheckListItem item;
                    JList list = (JList)event.getSource();
                    int index = list.locationToIndex(event.getPoint());
                    item.setSelected(!(item = (CheckListItem)list.getModel().getElementAt(index)).isSelected());
                    ExportAppDlg.this.refreshPluginJars();
                    list.repaint(list.getCellBounds(index, index));
                }
            });
        }
        return this.pluginsToIncludeList;
    }

    private CheckListItem[] getPluginItems() {
        Set<String> plugins = DAOFacade.getPluginNames();
        CheckListItem[] items = new CheckListItem[plugins.size()];
        int i = 0;
        for (String fileName : plugins) {
            items[i] = new CheckListItem(fileName, true);
            ++i;
        }
        return items;
    }

    private void initUserTypeGrp() {
        this.userTypeGrp = new ButtonGroup();
        this.userTypeGrp.add(this.getDesignerRad());
        this.userTypeGrp.add(this.getEndUserRad());
    }

    private JLabel getPluginJarsToIncludeLbl() {
        if (this.pluginJarsToIncludeLbl == null) {
            this.pluginJarsToIncludeLbl = new JLabel();
            this.pluginJarsToIncludeLbl.setText("These jar files will be added:");
        }
        return this.pluginJarsToIncludeLbl;
    }

    private JScrollPane getPluginJarsToIncludeSPn() {
        if (this.pluginJarsToIncludeSPn == null) {
            this.pluginJarsToIncludeSPn = new JScrollPane();
            this.pluginJarsToIncludeSPn.setViewportView(this.getPluginJars());
        }
        return this.pluginJarsToIncludeSPn;
    }

    private JList getPluginJars() {
        if (this.pluginJarsList == null) {
            this.pluginJarsList = new JList();
            this.refreshPluginJars();
        }
        return this.pluginJarsList;
    }

    private void refreshPluginJars() {
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        ListModel pluginsModel = null;
        if (this.pluginsToIncludeList != null) {
            pluginsModel = this.pluginsToIncludeList.getModel();
        }
        this.selectedPlugins = new HashSet<String>();
        if (this.pluginJarsList != null) {
            listModel = new DefaultListModel();
            int size = pluginsModel.getSize();
            int i = 0;
            while (i < size) {
                CheckListItem item = (CheckListItem)pluginsModel.getElementAt(i);
                if (item.isSelected()) {
                    this.selectedPlugins.add(item.toString());
                    for (String s : DAOFacade.getPluginJars(item.toString())) {
                        if (listModel.contains(s)) continue;
                        listModel.addElement(s);
                    }
                }
                ++i;
            }
        }
        this.pluginJarsList.setModel(listModel);
    }

    private JLabel getUserTypeLbl() {
        if (this.userTypeLbl == null) {
            this.userTypeLbl = new JLabel();
            this.userTypeLbl.setText("Select the user type:");
        }
        return this.userTypeLbl;
    }

    private JRadioButton getDesignerRad() {
        if (this.designerRad == null) {
            this.designerRad = new JRadioButton();
            this.designerRad.setText("Designer");
        }
        return this.designerRad;
    }

    private JRadioButton getEndUserRad() {
        if (this.endUserRad == null) {
            this.endUserRad = new JRadioButton();
            this.endUserRad.setSelected(true);
            this.endUserRad.setText("End-User");
        }
        return this.endUserRad;
    }

    private JButton getExportAppBtn() {
        if (this.exportAppBtn == null) {
            this.exportAppBtn = new JButton("Export application");
            this.exportAppBtn.addActionListener(this);
        }
        return this.exportAppBtn;
    }

    private static void installLnF() {
        try {
            String lnfClassname = PREFERRED_LOOK_AND_FEEL;
            if (lnfClassname == null) {
                lnfClassname = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(lnfClassname);
        }
        catch (Exception e) {
            System.err.println("Cannot install com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel on this platform:" + e.getMessage());
        }
    }

    public static void main(String[] args) {
        ExportAppDlg.installLnF();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExportAppDlg dialog = new ExportAppDlg();
                dialog.setDefaultCloseOperation(2);
                dialog.setTitle("ExportAppDlg");
                dialog.setLocationRelativeTo(null);
                dialog.getContentPane().setPreferredSize(dialog.getSize());
                dialog.pack();
                dialog.setVisible(true);
            }
        });
    }

    public void loadInfo() {
        ExportAppDlg.installLnF();
        this.setDefaultCloseOperation(2);
        this.setTitle("ExportAppDlg");
        this.setLocationRelativeTo(null);
        this.getContentPane().setPreferredSize(this.getSize());
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        int i = JOptionPane.showConfirmDialog(this, "Are you sure you want to export the application with id " + this.appId + "? ", "Export custom application", 0);
        if (i == 0) {
            String userType = this.userTypeGrp.getSelection().getActionCommand();
            DefaultListModel model = (DefaultListModel)this.pluginJarsList.getModel();
            HashSet<String> filesToDelete = new HashSet<String>();
            for (String s : DAOFacade.listPluginFiles()) {
                if (model.contains(s)) continue;
                filesToDelete.add(s);
            }
            DAOFacade.exportApp(this.appId, userType, filesToDelete, this.selectedPlugins);
            JOptionPane.showMessageDialog(this, "Custom application successfully exported!");
            this.dispose();
        }
    }
}

