/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.data;

import ecoSim.data.AbstractEcoSimData;
import ecoSim.factory.IParametersStrategy;
import ecoSim.gui.ConsolePrintStream;
import ecoSim.gui.ProgressBarFileInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import java.util.zip.ZipInputStream;
import javax.swing.JProgressBar;
import org.gcn.plinguacore.parser.input.InputParserFactory;
import org.gcn.plinguacore.parser.input.plingua.PlinguaInputParser;
import org.gcn.plinguacore.simulator.ISimulator;
import org.gcn.plinguacore.simulator.cellLike.probabilistic.ProbabilisticPsystemFactory;
import org.gcn.plinguacore.util.PlinguaCoreException;
import org.gcn.plinguacore.util.psystem.Psystem;
import org.gcn.plinguacore.util.psystem.factory.IPsystemFactory;

class ProxySimulator {
    private static final Checksum checksum = new Adler32();
    private long pLinguaFileChecksum = 0L;
    private int parametersHashCode = 0;
    protected Psystem proxyPsystem = null;
    protected long transientPlinguaFileChecksum = 0L;
    protected int transientParametersHashCode = 0;
    private File simulatorFile;

    public ProxySimulator(File simulatorFile) {
        this.simulatorFile = simulatorFile;
    }

    private boolean loadProxy(ConsolePrintStream info) {
        if (!this.simulatorFile.exists()) {
            return false;
        }
        if (this.proxyPsystem == null) {
            try {
                if (info != null) {
                    info.println("Loading " + this.simulatorFile.getAbsolutePath());
                    info.println("Wait, please...");
                }
                ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.simulatorFile));
                zipInputStream.getNextEntry();
                ObjectInputStream stream = new ObjectInputStream(zipInputStream);
                this.parametersHashCode = stream.readInt();
                this.pLinguaFileChecksum = stream.readLong();
                this.proxyPsystem = (Psystem)stream.readObject();
                this.proxyPsystem.setAbstractPsystemFactory((IPsystemFactory)ProbabilisticPsystemFactory.getInstance());
                zipInputStream.closeEntry();
                zipInputStream.close();
                stream.close();
                if (info != null) {
                    info.println("Loaded!");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    protected boolean checkParameters(Map<String, Number> parameters) {
        this.transientParametersHashCode = parameters.hashCode();
        return this.transientParametersHashCode == this.parametersHashCode;
    }

    protected boolean checkPlinguaFileChecksum(File pLinguaFile) throws IOException {
        if (pLinguaFile == null) {
            return false;
        }
        this.transientPlinguaFileChecksum = ProxySimulator.calculateChecksum(pLinguaFile);
        return this.transientPlinguaFileChecksum == this.pLinguaFileChecksum;
    }

    protected static ISimulator readPLinguaFile(Map<String, Number> parameters, File pLinguaFile, ConsolePrintStream error, ConsolePrintStream warning, ConsolePrintStream info, IParametersStrategy strategy, int verbosity, JProgressBar bar, String algorithm) {
        ISimulator simulator;
        block16: {
            simulator = null;
            if (pLinguaFile != null) {
                PrintStream err;
                PrintStream war;
                PrintStream inf;
                if (info == null) {
                    inf = System.out;
                } else {
                    info.clear();
                    inf = info;
                    ProxySimulator.printParameters(parameters, info);
                }
                if (warning == null) {
                    war = System.out;
                } else {
                    warning.clear();
                    war = warning;
                }
                if (error == null) {
                    err = System.out;
                } else {
                    error.clear();
                    err = error;
                }
                try {
                    ProgressBarFileInputStream stream = new ProgressBarFileInputStream(pLinguaFile, bar);
                    try {
                        InputParserFactory pf = new InputParserFactory();
                        PlinguaInputParser parser = (PlinguaInputParser)pf.createParser("P-Lingua");
                        parser.setErrorChannel(err);
                        parser.setWarningChannel(war);
                        parser.setInfoChannel(inf);
                        parser.setMsgChannel(inf);
                        parser.setVerbosityLevel(verbosity);
                        parser.getParameters().putAll(parameters);
                        Psystem ps = parser.parse((InputStream)stream);
                        String simulador = "";
                        if (algorithm != null && !algorithm.equals("")) {
                            simulador = algorithm;
                        } else {
                            Iterator it = ps.getSimulatorsIDs();
                            while (it.hasNext()) {
                                simulador = (String)it.next();
                            }
                        }
                        System.out.println("Current simulator: " + simulador);
                        System.out.println("Alphabet size: " + ps.getAlphabet().size());
                        System.out.println("Number of membranes: " + ps.getMembraneStructure().getAllMembranes().size());
                        if (simulador.equals("")) {
                            simulador = "dndp4";
                        }
                        simulator = ps.createSimulator(false, false, simulador);
                        simulator.setInfoChannel(inf);
                    }
                    catch (PlinguaCoreException ex) {
                        if (ex instanceof PlinguaCoreException) {
                            error.println(ex.getMessage());
                            break block16;
                        }
                        ex.printStackTrace((PrintStream)error);
                    }
                }
                catch (FileNotFoundException e) {
                    error.println(e.getMessage());
                }
            }
        }
        return simulator;
    }

    protected void saveProxy(Psystem psystem, Map<String, Number> parameters, File pLinguaFile, ConsolePrintStream info) {
        try {
            this.parametersHashCode = this.transientParametersHashCode != 0 ? this.transientParametersHashCode : parameters.hashCode();
            this.pLinguaFileChecksum = this.transientPlinguaFileChecksum != 0L ? this.transientPlinguaFileChecksum : ProxySimulator.calculateChecksum(pLinguaFile);
            this.proxyPsystem = psystem;
        }
        catch (Exception ex) {
            this.parametersHashCode = 0;
            this.pLinguaFileChecksum = 0L;
            this.proxyPsystem = null;
        }
    }

    private static void printParameters(Map<String, Number> map, ConsolePrintStream info) {
        Iterator<String> it = map.keySet().iterator();
        info.println("Parameters:");
        while (it.hasNext()) {
            String key = it.next();
            Number value = map.get(key);
            info.println(String.valueOf(key) + " = " + value);
        }
    }

    private static void printObjects(Map<String, Number> map, ConsolePrintStream info) {
        Iterator<String> it = map.keySet().iterator();
        info.println("Objects:");
        while (it.hasNext()) {
            String key = it.next();
            Number value = map.get(key);
            info.println(String.valueOf(key) + " = " + value);
        }
    }

    public void getSimulator(AbstractEcoSimData data, ConsolePrintStream error, ConsolePrintStream warning, ConsolePrintStream info, IParametersStrategy strategy, int verbosity, JProgressBar bar, String algorithm) {
        this.transientPlinguaFileChecksum = 0L;
        this.transientParametersHashCode = 0;
        ISimulator simulator = null;
        try {
            Map<String, Number> parameters = strategy.getInitialParameters(data);
            if (this.checkParameters(parameters) && this.checkPlinguaFileChecksum(data.getPlinguaFile())) {
                String simulador = "";
                if (algorithm != null && !algorithm.equals("")) {
                    simulador = algorithm;
                } else {
                    Iterator it = this.proxyPsystem.getSimulatorsIDs();
                    while (it.hasNext()) {
                        simulador = (String)it.next();
                    }
                    if (simulador.equals("")) {
                        simulador = "binomial";
                    }
                }
                System.out.println("Current simulator: " + simulador);
                System.out.println("Alphabet size: " + this.proxyPsystem.getAlphabet().size());
                System.out.println("Number of membranes: " + this.proxyPsystem.getMembraneStructure().getAllMembranes().size());
                simulator = this.proxyPsystem.createSimulator(false, false, simulador);
                simulator.setInfoChannel((PrintStream)info);
            } else {
                simulator = ProxySimulator.readPLinguaFile(parameters, data.getPlinguaFile(), error, warning, info, strategy, verbosity, bar, data.getSimulationAlgorithm());
                if (simulator != null) {
                    this.saveProxy(simulator.getPsystem(), parameters, data.getPlinguaFile(), info);
                }
            }
        }
        catch (Exception ex) {
            if (ex.getMessage() == null || ex.getMessage().equals("")) {
                ex.printStackTrace(error);
            }
            error.println(ex.getMessage());
            ex.printStackTrace(error);
        }
        data.setSimulator(simulator);
        data.notifyListeners(null);
    }

    private static long calculateChecksum(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        stream.read(bytes);
        stream.close();
        checksum.reset();
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }
}

