/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.data;

import ecoSim.data.AbstractEcoSimData;
import ecoSim.data.ProxySimulator;
import ecoSim.factory.CustomEcoSimData;
import ecoSim.factory.IParametersStrategy;
import ecoSim.gui.ConsolePrintStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JProgressBar;
import org.gcn.plinguacore.simulator.ISimulator;

public class CustomProxySimulator
extends ProxySimulator {
    public CustomProxySimulator(File simulatorFile) {
        super(simulatorFile);
    }

    @Override
    public void getSimulator(AbstractEcoSimData data, ConsolePrintStream error, ConsolePrintStream warning, ConsolePrintStream info, IParametersStrategy strategy, int verbosity, JProgressBar bar, String algorithm) {
        this.transientPlinguaFileChecksum = 0L;
        this.transientParametersHashCode = 0;
        ISimulator simulator = null;
        try {
            Map<String, Number> parameters = strategy.getInitialParameters(data);
            if (this.checkParameters(parameters) && this.checkPlinguaFileChecksum(data.getPlinguaFile())) {
                String simulador = "";
                if (algorithm != null && !algorithm.equals("")) {
                    simulador = algorithm;
                } else {
                    Iterator it = this.proxyPsystem.getSimulatorsIDs();
                    while (it.hasNext()) {
                        simulador = (String)it.next();
                    }
                }
                if (simulador.equals("")) {
                    simulador = "dndp4";
                }
                System.out.println("Current simulator: " + simulador);
                System.out.println("Alphabet size: " + this.proxyPsystem.getAlphabet().size());
                System.out.println("Number of membranes: " + this.proxyPsystem.getMembraneStructure().getAllMembranes().size());
                simulator = this.proxyPsystem.createSimulator(false, false, simulador);
                simulator.setInfoChannel((PrintStream)info);
            } else {
                simulator = CustomProxySimulator.readPLinguaFile(parameters, data.getPlinguaFile(), error, warning, info, strategy, verbosity, bar, data.getSimulationAlgorithm());
                if (simulator != null) {
                    this.saveProxy(simulator.getPsystem(), parameters, data.getPlinguaFile(), info);
                }
            }
        }
        catch (Exception ex) {
            if (ex.getMessage() == null || ex.getMessage().equals("")) {
                ex.printStackTrace(error);
            }
            error.println(ex.getMessage());
        }
        data.setSimulator(simulator);
        data.notifyListeners(null);
    }

    public void getSimulator(CustomEcoSimData data, ConsolePrintStream error, ConsolePrintStream warning, ConsolePrintStream info, IParametersStrategy strategy, int verbosity, JProgressBar bar, String algorithm) {
        this.transientPlinguaFileChecksum = 0L;
        this.transientParametersHashCode = 0;
        ISimulator simulator = null;
        try {
            Map<String, Number> parameters = strategy.getInitialParameters(data);
            if (this.checkParameters(parameters) && this.checkPlinguaFileChecksum(data.getPlinguaFile())) {
                String simulador = "";
                if (algorithm != null && !algorithm.equals("")) {
                    simulador = algorithm;
                } else {
                    Iterator it = this.proxyPsystem.getSimulatorsIDs();
                    while (it.hasNext()) {
                        simulador = (String)it.next();
                    }
                }
                if (simulador.equals("")) {
                    simulador = "dndp4";
                }
                System.out.println("Current simulator: " + simulador);
                System.out.println("Alphabet size: " + this.proxyPsystem.getAlphabet().size());
                System.out.println("Number of membranes: " + this.proxyPsystem.getMembraneStructure().getAllMembranes().size());
                simulator = this.proxyPsystem.createSimulator(false, false, simulador);
                simulator.setInfoChannel((PrintStream)info);
            } else {
                simulator = CustomProxySimulator.readPLinguaFile(parameters, data.getPlinguaFile(), error, warning, info, strategy, verbosity, bar, data.getSimulationAlgorithm());
                if (simulator != null) {
                    this.saveProxy(simulator.getPsystem(), parameters, data.getPlinguaFile(), info);
                }
            }
        }
        catch (Exception ex) {
            if (ex.getMessage() == null || ex.getMessage().equals("")) {
                ex.printStackTrace(error);
            }
            error.println(ex.getMessage());
        }
        data.setSimulator(simulator);
        data.notifyListeners(null);
    }
}

