/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.data;

import ecoSim.data.EcoSimStateEvent;
import ecoSim.data.EcoSimStateListener;
import ecoSim.data.EventController;
import ecoSim.data.ProxySimulator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import org.gcn.plinguacore.simulator.ISimulator;

public abstract class AbstractEcoSimCnfData
extends EventController<EcoSimStateListener, EcoSimStateEvent>
implements Serializable {
    public static final transient int STATE_INIT = 0;
    public static final transient int STATE_DEFAULT_DATA = 1;
    public static final transient int STATE_SAVED_DATA = 2;
    public static final transient int STATE_UNSAVED_DATA = 3;
    public static final transient int STATE_SIMULATING = 4;
    private static final long serialVersionUID = -6353376621637004621L;
    private transient File plinguaFile;
    private transient boolean userMode;
    private transient File defaultDataFile;
    private transient File defaultPlinguaFile;
    private transient String applicationName;
    private transient String applicationVersion;
    private transient File cnfFile;
    private transient String simulationAlgorithm;
    private transient File dataFile = null;
    private transient File systemDirectory = new File(System.getProperty("user.dir"));
    private transient int state = 0;
    private transient int stepsByCycle;
    private transient int simulatedCycles;
    private transient int simulationsByCycle;
    private int applicationID;
    private transient String factoryName;
    private transient int oldState;
    private transient ISimulator simulator = null;
    private transient ProxySimulator proxySimulator = null;

    public AbstractEcoSimCnfData(String factoryName, int applicationID, String applicationName, String applicationVersion) {
        this.defaultDataFile = new File(this.systemDirectory, "def_" + applicationID + ".ec2");
        this.cnfFile = new File(this.systemDirectory, "eco_" + applicationID + ".cnf");
        this.defaultPlinguaFile = new File(this.systemDirectory, "model_" + applicationID + ".pli");
        this.proxySimulator = new ProxySimulator(new File(this.systemDirectory, "sim_" + applicationID + ".bin"));
        this.userMode = false;
        this.stepsByCycle = 4;
        this.simulatedCycles = 25;
        this.simulationsByCycle = 10;
        this.factoryName = factoryName;
        this.applicationID = applicationID;
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public int getStepsByCycle() {
        return this.stepsByCycle;
    }

    public void setStepsByCycle(int stepsByCycle) {
        if (stepsByCycle < 1) {
            return;
        }
        this.stepsByCycle = stepsByCycle;
        this.notifyListeners(null);
    }

    public int getSimulatedCycles() {
        return this.simulatedCycles;
    }

    public void setSimulatedCycles(int simulatedCycles) {
        if (simulatedCycles < 0) {
            return;
        }
        this.simulatedCycles = simulatedCycles;
        this.notifyListeners(null);
    }

    public int getSimulationsByCycle() {
        return this.simulationsByCycle;
    }

    public void setSimulationsByCycle(int simulationsByCycle) {
        if (simulationsByCycle < 1) {
            return;
        }
        this.simulationsByCycle = simulationsByCycle;
        this.notifyListeners(null);
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public void reset() {
        if (this.load(this.getDefaultDataFile())) {
            this.setState(1);
        }
    }

    protected void setDataFile(File dataFile) {
        if (dataFile == null) {
            this.dataFile = null;
            this.notifyListeners(null);
        } else if (!dataFile.equals(this.dataFile)) {
            this.dataFile = dataFile;
            this.notifyListeners(null);
        }
    }

    public File getDefaultPlinguaFile() {
        return this.defaultPlinguaFile;
    }

    private void initUserMode() {
        this.userMode = true;
    }

    public int getState() {
        return this.state;
    }

    public boolean existsDefaultDataFile() {
        return this.defaultDataFile.exists();
    }

    public void beginSimulationState() {
        this.oldState = this.state;
        this.setState(4);
    }

    public void endSimulationState() {
        this.setState(this.oldState);
    }

    protected void setState(int state) {
        if (state != this.state) {
            int oldState = this.state;
            this.state = state;
            this.notifyListeners(new EcoSimStateEvent(this, oldState, state, ""));
        }
    }

    public boolean saveCnfFile() {
        FileWriter file = null;
        PrintWriter pw = null;
        try {
            file = new FileWriter(this.cnfFile);
            pw = new PrintWriter(file);
            if (this.userMode) {
                pw.println("mode=user");
            } else if (this.plinguaFile != null && !this.plinguaFile.getPath().equals("")) {
                pw.println("model=" + this.plinguaFile.getAbsolutePath());
            }
            pw.println("steps_by_cycle=" + this.stepsByCycle);
            pw.println("simulated_cycles=" + this.simulatedCycles);
            pw.println("simulations_by_cycle=" + this.simulationsByCycle);
            if (this.dataFile != null) {
                pw.println("data=" + this.dataFile.getAbsolutePath());
            }
            file.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadCnfFile() {
        boolean userModeAux = false;
        String plinguaFileAux = null;
        String dataFileAux = null;
        String simulatedYearsAux = null;
        String simulationsByYearAux = null;
        String stepsByYearAux = null;
        try {
            FileReader fr = new FileReader(this.cnfFile);
            BufferedReader br = new BufferedReader(fr);
            try {
                block23: {
                    String line = br.readLine();
                    while (true) {
                        if (line == null) {
                            fr.close();
                            if (!userModeAux) break;
                            this.initUserMode();
                            break block23;
                        }
                        String str = line.replaceAll(" ", "");
                        if (str.equals("mode=user")) {
                            userModeAux = true;
                        } else if (str.indexOf("model=") == 0) {
                            plinguaFileAux = str.substring(6);
                        } else if (str.indexOf("data=") == 0) {
                            dataFileAux = str.substring(5);
                        } else if (str.indexOf("steps_by_cycle=") == 0) {
                            stepsByYearAux = str.substring(14);
                        } else if (str.indexOf("simulated_cycles=") == 0) {
                            simulatedYearsAux = str.substring(16);
                        } else if (str.indexOf("simulations_by_cycle=") == 0) {
                            simulationsByYearAux = str.substring(20);
                        }
                        line = br.readLine();
                    }
                    this.userMode = false;
                    if (plinguaFileAux != null) {
                        this.plinguaFile = new File(plinguaFileAux);
                    }
                }
                if (dataFileAux != null) {
                    this.load(new File(dataFileAux));
                }
                int a = this.stepsByCycle;
                int b = this.simulatedCycles;
                int c = this.simulationsByCycle;
                try {
                    if (stepsByYearAux != null) {
                        this.stepsByCycle = Integer.parseInt(stepsByYearAux);
                    }
                    if (simulatedYearsAux != null) {
                        this.simulatedCycles = Integer.parseInt(simulatedYearsAux);
                    }
                    if (simulationsByYearAux == null) return true;
                    this.simulationsByCycle = Integer.parseInt(simulationsByYearAux);
                    return true;
                }
                catch (NumberFormatException ex) {
                    this.stepsByCycle = a;
                    this.simulatedCycles = b;
                    this.simulationsByCycle = c;
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        catch (FileNotFoundException e2) {
            return false;
        }
    }

    public abstract boolean load(File var1);

    public abstract boolean save(File var1, boolean var2);

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public int getApplicationID() {
        return this.applicationID;
    }

    public File getPlinguaFile() {
        return this.plinguaFile;
    }

    public void setPlinguaFile(File plinguaFile) {
        this.plinguaFile = plinguaFile;
        this.setSimulator(null);
        this.notifyListeners(new EcoSimStateEvent(this, this.getState(), this.getState(), "Set Model"));
    }

    public boolean isUserMode() {
        return this.userMode;
    }

    public void setUserMode(boolean userMode) {
        this.userMode = userMode;
        if (userMode) {
            this.initUserMode();
        }
    }

    public File getDefaultDataFile() {
        return this.defaultDataFile;
    }

    @Override
    protected final void notifyListener(EcoSimStateListener listener, EcoSimStateEvent event) {
        listener.ecoSimStateChanged(event);
    }

    public ISimulator getSimulator() {
        return this.simulator;
    }

    protected void setSimulator(ISimulator simulator) {
        this.simulator = simulator;
    }

    protected final ProxySimulator getProxySimulator() {
        return this.proxySimulator;
    }

    public void setSimulationAlgorithm(String simulationAlgorithm) {
        this.simulationAlgorithm = simulationAlgorithm;
        this.notifyListeners(null);
    }

    public String getSimulationAlgorithm() {
        return this.simulationAlgorithm;
    }
}

