/*
 * Decompiled with CFR 0.152.
 */
package ecoSim;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class SimpleZip {
    private static ZipOutputStream zos;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java SimpleZip directoryName");
            System.exit(0);
        }
        String fileName = args[0];
        try {
            SimpleZip.makeZip(fileName);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static void makeZip(String fileName) throws IOException, FileNotFoundException {
        File file = new File(fileName);
        zos = new ZipOutputStream(new FileOutputStream(file + ".zip"));
        SimpleZip.recurseFiles(file);
        zos.close();
    }

    private static void recurseFiles(File file) throws IOException, FileNotFoundException {
        if (file.isDirectory()) {
            String[] fileNames = file.list();
            if (fileNames != null) {
                int i = 0;
                while (i < fileNames.length) {
                    SimpleZip.recurseFiles(new File(file, fileNames[i]));
                    ++i;
                }
            }
        } else {
            int len;
            byte[] buf = new byte[1024];
            ZipEntry zipEntry = new ZipEntry(file.toString());
            FileInputStream fin = new FileInputStream(file);
            BufferedInputStream in = new BufferedInputStream(fin);
            zos.putNextEntry(zipEntry);
            while ((len = in.read(buf)) >= 0) {
                zos.write(buf, 0, len);
            }
            in.close();
            zos.closeEntry();
        }
    }
}

