/*
 * Decompiled with CFR 0.152.
 */
package ecoSim;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class OnMemoryDBManager {
    private static OnMemoryDBManager connection = null;
    private Connection conn = null;

    private OnMemoryDBManager() {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            this.conn = DriverManager.getConnection("jdbc:hsqldb:mem:memoriadb");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static OnMemoryDBManager getInstance() {
        try {
            if (connection == null || OnMemoryDBManager.connection.conn.isClosed()) {
                connection = new OnMemoryDBManager();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return connection;
    }

    public Connection getConnection() {
        return this.conn;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Statement st = this.conn.createStatement();
        st.executeUpdate("SHUTDOWN");
        st.close();
        this.conn.close();
    }
}

