/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Parameter;
import db.Species;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Ecosystem
implements Serializable {
    private static final long serialVersionUID = -8106602599022039820L;
    private static Ecosystem singleton = null;
    private List<Species> species = new ArrayList<Species>();
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private String pLinguaFile = null;
    private int zones = 1;

    private Ecosystem() {
    }

    public static boolean existsParameter(String parameterName, int parameterID) {
        boolean r = false;
        Iterator<Species> it = Ecosystem.getInstance().getSpecies().iterator();
        while (it.hasNext() && !r) {
            Species s = it.next();
            String key = String.valueOf(parameterName) + "{" + (s.getId() + 1) + "," + parameterID + "}";
            r = s.getParameters().containsKey(key);
        }
        return r;
    }

    private double[] getAlphaValue() {
        double[] value = new double[this.zones];
        int i = 0;
        while (i < this.zones) {
            value[i] = 0.0;
            ++i;
        }
        if (this.species.size() > 0) {
            int j = 0;
            while (j < this.zones) {
                int i2 = 1;
                while (i2 <= 25) {
                    Double v = this.zones == 1 ? this.species.get(0).getParameters().get("q{1," + i2 + "}") : this.species.get(0).getParameters().get("q{1," + i2 + "," + (j + 1) + "}");
                    if (v != null) {
                        int n = j;
                        value[n] = value[n] + v;
                    }
                    ++i2;
                }
                value[j] = Math.ceil(value[j] * 682.0 * 1.1);
                ++j;
            }
        }
        return value;
    }

    public void setNumberOfSpecies(int n) {
        block3: {
            block2: {
                if (n <= this.species.size()) break block2;
                int i = this.species.size();
                while (i < n) {
                    this.species.add(new Species("", i));
                    ++i;
                }
                break block3;
            }
            if (n >= this.species.size()) break block3;
            n = this.species.size() - n;
            int i = 0;
            while (i < n) {
                this.species.remove(this.species.size() - 1);
                ++i;
            }
        }
    }

    public String getPLinguaFile() {
        return this.pLinguaFile;
    }

    public void setPLinguaFile(String plinguaFile) {
        this.pLinguaFile = plinguaFile;
    }

    public void setNumberOfParameters(int n) {
        int i;
        if (n > this.parameters.size()) {
            i = this.parameters.size();
            while (i < n) {
                this.parameters.add(new Parameter(i));
                ++i;
            }
        }
        if (n < this.parameters.size()) {
            n = this.parameters.size() - n;
            i = 0;
            while (i < n) {
                this.parameters.remove(this.parameters.size() - 1);
                ++i;
            }
        }
    }

    public List<Species> getSpecies() {
        return this.species;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean load(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            try {
                ObjectInputStream stream = new ObjectInputStream(inputStream);
                try {
                    Object obj = stream.readObject();
                    stream.close();
                    if (!(obj instanceof Ecosystem)) {
                        return false;
                    }
                    singleton = (Ecosystem)obj;
                    if (singleton.getZones() == 0) {
                        singleton.setZones(1);
                    }
                    return true;
                }
                catch (ClassNotFoundException e) {
                    return false;
                }
            }
            catch (IOException e) {
                return false;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(File file) {
        try {
            FileOutputStream fileStream = new FileOutputStream(file);
            try {
                ObjectOutputStream objectStream = new ObjectOutputStream(fileStream);
                objectStream.writeObject(this);
                objectStream.close();
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        catch (FileNotFoundException e2) {
            return false;
        }
    }

    public void clear() {
        this.species.clear();
        this.parameters.clear();
        this.pLinguaFile = null;
    }

    public Map<String, Number> getParameterValues() {
        HashMap<String, Double> map = new HashMap<String, Double>();
        if (this.zones == 1) {
            map.put("alpha", this.getAlphaValue()[0]);
        } else {
            double[] v = this.getAlphaValue();
            int i = 0;
            while (i < this.zones) {
                map.put("alpha{" + (i + 1) + "}", v[i]);
                ++i;
            }
        }
        int i = 0;
        while (i < this.species.size()) {
            Number value;
            Double doubleValue;
            int j = 0;
            while (j < this.parameters.size()) {
                String param = this.parameters.get(j).getName();
                int id = this.parameters.get(j).getId() + 1;
                param = String.valueOf(param) + "{" + (i + 1) + "," + id + "}";
                doubleValue = this.species.get(i).getParameters().get(param);
                if (doubleValue == null) {
                    doubleValue = new Double(0.0);
                }
                value = (double)doubleValue.intValue() == doubleValue ? (Number)new Integer(doubleValue.intValue()) : (Number)doubleValue;
                map.put(param, (Double)value);
                ++j;
            }
            int k = 0;
            while (k < this.zones) {
                int j2 = 0;
                while (j2 < 25) {
                    String param = this.zones == 1 ? "q{" + (i + 1) + "," + (j2 + 1) + "}" : "q{" + (i + 1) + "," + (j2 + 1) + "," + (k + 1) + "}";
                    doubleValue = this.species.get(i).getParameters().get(param);
                    if (doubleValue == null || !this.species.get(i).isIncluded()) {
                        doubleValue = new Double(0.0);
                    }
                    value = (double)doubleValue.intValue() == doubleValue ? (Number)new Integer(doubleValue.intValue()) : (Number)doubleValue;
                    map.put(param, (Double)value);
                    ++j2;
                }
                ++k;
            }
            ++i;
        }
        return Collections.unmodifiableMap(map);
    }

    public void setPopulationValue(int zone, int speciesID, int age, double population) {
        String key = this.zones == 1 ? "q{" + speciesID + "," + age + "}" : "q{" + speciesID + "," + age + "," + zone + "}";
        Species s = this.species.get(speciesID - 1);
        if (s != null) {
            s.getParameters().put(key, population);
        }
    }

    public void setParameterValue(int speciesID, int parameterID, double value) {
        String name = parameterID - 1 < this.parameters.size() && parameterID > 0 ? this.parameters.get(parameterID - 1).getName() : "k";
        String key = String.valueOf(name) + "{" + speciesID + "," + parameterID + "}";
        Species s = this.species.get(speciesID - 1);
        if (s != null) {
            s.getParameters().put(key, value);
        }
    }

    public void setParameterValue(String parameterName, int speciesID, int parameterID, double value) {
        String key = String.valueOf(parameterName) + "{" + speciesID + "," + parameterID + "}";
        Species s = this.species.get(speciesID - 1);
        if (s != null) {
            s.getParameters().put(key, value);
        }
    }

    public static Ecosystem getInstance() {
        if (singleton == null) {
            singleton = new Ecosystem();
        }
        return singleton;
    }

    public int getZones() {
        return this.zones;
    }

    public synchronized void setZones(int zones) {
        HashMap<String, Double> params = new HashMap<String, Double>();
        if (zones > 1 && this.zones == 1) {
            int i = 0;
            while (i < this.species.size()) {
                Iterator<String> it = this.species.get(i).getParameters().keySet().iterator();
                params.clear();
                while (it.hasNext()) {
                    String p = it.next();
                    if (p.charAt(0) == 'q') {
                        String p1 = p.substring(0, p.length() - 1);
                        int j = 0;
                        while (j < zones) {
                            params.put(String.valueOf(p1) + "," + (j + 1) + "}", this.species.get(i).getParameters().get(p));
                            ++j;
                        }
                        continue;
                    }
                    params.put(p, this.species.get(i).getParameters().get(p));
                }
                this.species.get(i).getParameters().clear();
                this.species.get(i).getParameters().putAll(params);
                ++i;
            }
        } else if (zones == 1 && this.zones > 1) {
            int i = 0;
            while (i < this.species.size()) {
                Iterator<String> it = this.species.get(i).getParameters().keySet().iterator();
                params.clear();
                while (it.hasNext()) {
                    String p = it.next();
                    if (p.charAt(0) == 'q') {
                        String p1 = p.substring(0, p.lastIndexOf(","));
                        params.put(String.valueOf(p1) + "}", this.species.get(i).getParameters().get(p));
                        continue;
                    }
                    params.put(p, this.species.get(i).getParameters().get(p));
                }
                this.species.get(i).getParameters().clear();
                this.species.get(i).getParameters().putAll(params);
                ++i;
            }
        }
        this.zones = zones;
    }
}

