/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui;

import ecoSim.actions.AbstractEcoSimAction;
import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.gui.AbstractEcoSimView;
import ecoSim.gui.EcoSimFileFilter;
import ecoSim.gui.EcoSimViewButton;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jfree.chart.JFreeChart;

public abstract class AbstractGraphicsEcoSimView
extends AbstractEcoSimView {
    private BufferedImage image = null;
    public JFreeChart chart = null;
    private int height = 300;
    private int width = 500;

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public AbstractGraphicsEcoSimView(JFreeChart chart, String name, boolean border, AbstractEcoSimGUI gui, int width, int height) {
        super(name, border, gui);
        this.chart = chart;
        this.getButtons().add(new EcoSimViewButton("Save As...", new EcoSimSaveImageAsAction(), gui));
        this.height = height;
        this.width = width;
    }

    protected final BufferedImage getImage() {
        if (this.image == null) {
            this.image = this.createImage();
        }
        return this.image;
    }

    protected abstract BufferedImage createImage();

    private void saveImage(File file) throws IOException {
        ImageIO.write((RenderedImage)this.getImage(), "png", file);
    }

    class EcoSimSaveImageAsAction
    extends AbstractEcoSimAction {
        EcoSimSaveImageAsAction() {
        }

        @Override
        protected void doSecureAction(AbstractEcoSimGUI gui) {
            JFileChooser chooser = new JFileChooser();
            EcoSimFileFilter filter = new EcoSimFileFilter(5);
            chooser.setFileFilter(filter);
            int returnVal = chooser.showSaveDialog(gui.getFrame());
            if (returnVal == 0) {
                File f = filter.completeExtension(chooser.getSelectedFile());
                try {
                    AbstractGraphicsEcoSimView.this.saveImage(f);
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(gui.getFrame(), "Unable to save", "Error", 0);
                }
            }
        }

        @Override
        public boolean isEnabledAction(AbstractEcoSimGUI gui) {
            return gui.getData().getState() != 4;
        }
    }
}

