/*
 * Decompiled with CFR 0.152.
 */
package ecoSim;

import ecoSim.DAOFacade;
import ecoSim.ExportAppDlg;
import ecoSim.LoadConfigFileDlg;
import ecoSim.gui.ConfigFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.dyno.visual.swing.layouts.Constraints;
import org.dyno.visual.swing.layouts.GroupLayout;
import org.dyno.visual.swing.layouts.Leading;

public class SelectApplicationFrm
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JLabel appListLbl;
    private JTable appListTbl;
    private JScrollPane appListSPn;
    private JButton runAppBtn;
    private JButton loadConfigFileBtn;
    private JButton deleteAppBtn;
    private JButton exportCustomAppBtn;
    private JTextArea consoleTxa;
    private JScrollPane jScrollPane0;
    private JMenuItem loadAppMenuItem;
    private JMenu fileMenu;
    private JMenuBar mecosimMbar;
    private JMenuItem ExitMenuItem;
    private PipedOutputStream pipeOut;
    private PipedInputStream pipeIn;
    private JMenuItem runMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem exportMenuItem;
    private static final String PREFERRED_LOOK_AND_FEEL = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";

    public SelectApplicationFrm() {
        this.setResizable(false);
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle("MeCoSim - Application Selection");
        this.setBackground(new Color(128, 255, 128));
        this.setResizable(false);
        this.setLayout(new GroupLayout());
        this.add((Component)this.getAppListLbl(), new Constraints(new Leading(25, 429, 10, 10), new Leading(21, 10, 10)));
        this.add((Component)this.getAppListSPn(), new Constraints(new Leading(24, 981, 10, 10), new Leading(51, 232, 10, 10)));
        this.add((Component)this.getJScrollPane0(), new Constraints(new Leading(205, 625, 10, 10), new Leading(341, 192, 10, 10)));
        this.add((Component)this.getLoadConfigFileBtn(), new Constraints(new Leading(377, 137, 10, 10), new Leading(295, 12, 12)));
        this.add((Component)this.getRunAppBtn(), new Constraints(new Leading(231, 137, 10, 10), new Leading(295, 12, 12)));
        this.add((Component)this.getDeleteAppBtn(), new Constraints(new Leading(524, 137, 10, 10), new Leading(295, 12, 12)));
        this.add((Component)this.getExportCustomAppBtn(), new Constraints(new Leading(667, 137, 10, 10), new Leading(295, 12, 12)));
        this.redirectSystemStreams();
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent event) {
                SelectApplicationFrm.this.windowFocusWindowGainedFocus(event);
            }

            @Override
            public void windowLostFocus(WindowEvent event) {
            }
        });
        this.setJMenuBar(this.getJMenuBar0());
        this.setSize(1033, 574);
    }

    private void redirectSystemStreams() {
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                SelectApplicationFrm.this.updateTextPane(String.valueOf((char)b));
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                SelectApplicationFrm.this.updateTextPane(new String(b, off, len));
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }
        };
        System.setOut(new PrintStream(out, true));
        System.setErr(new PrintStream(out, true));
    }

    protected void updateTextPane(final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Document doc = SelectApplicationFrm.this.consoleTxa.getDocument();
                try {
                    doc.insertString(doc.getLength(), text, null);
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
                SelectApplicationFrm.this.consoleTxa.setCaretPosition(doc.getLength() - 1);
            }
        });
    }

    private JMenuItem getExitMenuItem() {
        if (this.ExitMenuItem == null) {
            this.ExitMenuItem = new JMenuItem("Exit");
            this.ExitMenuItem.addActionListener(this);
        }
        return this.ExitMenuItem;
    }

    private JMenuBar getJMenuBar0() {
        if (this.mecosimMbar == null) {
            this.mecosimMbar = new JMenuBar();
            this.mecosimMbar.add(this.getJMenu0());
        }
        return this.mecosimMbar;
    }

    private JMenu getJMenu0() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("Application");
            this.fileMenu.add(this.getRunMenuItem());
            this.fileMenu.add(this.getLoadMenuItem());
            this.fileMenu.add(this.getDeleteMenuItem());
            this.fileMenu.add(this.getExportMenuItem());
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getRunMenuItem() {
        if (this.runMenuItem == null) {
            this.runMenuItem = new JMenuItem("Run Application");
            this.runMenuItem.setToolTipText("Run the selected application");
            this.runMenuItem.addActionListener(this);
        }
        return this.runMenuItem;
    }

    private JMenuItem getLoadMenuItem() {
        if (this.loadAppMenuItem == null) {
            this.loadAppMenuItem = new JMenuItem("Load config file");
            this.loadAppMenuItem.setToolTipText("Load a new custom application (visual simulator) or reload an existing one");
            this.loadAppMenuItem.addActionListener(this);
        }
        return this.loadAppMenuItem;
    }

    private JMenuItem getDeleteMenuItem() {
        if (this.deleteMenuItem == null) {
            this.deleteMenuItem = new JMenuItem("Delete app");
            this.deleteMenuItem.setToolTipText("Run the selected application");
            this.deleteMenuItem.addActionListener(this);
        }
        return this.deleteMenuItem;
    }

    private JMenuItem getExportMenuItem() {
        if (this.exportMenuItem == null) {
            this.exportMenuItem = new JMenuItem("Export custom app");
            this.exportMenuItem.setToolTipText("Export the selected application");
            this.exportMenuItem.addActionListener(this);
        }
        return this.exportMenuItem;
    }

    private JScrollPane getJScrollPane0() {
        if (this.jScrollPane0 == null) {
            this.jScrollPane0 = new JScrollPane();
            this.jScrollPane0.setViewportView(this.getJTextArea0());
        }
        return this.jScrollPane0;
    }

    private JTextArea getJTextArea0() {
        if (this.consoleTxa == null) {
            this.consoleTxa = new JTextArea();
            this.consoleTxa.setAutoscrolls(true);
        }
        return this.consoleTxa;
    }

    private JButton getExportCustomAppBtn() {
        if (this.exportCustomAppBtn == null) {
            this.exportCustomAppBtn = new JButton("Export custom app");
            this.exportCustomAppBtn.setToolTipText("Export the selected application to a self-contained zip file");
            this.exportCustomAppBtn.addActionListener(this);
        }
        return this.exportCustomAppBtn;
    }

    private JButton getDeleteAppBtn() {
        if (this.deleteAppBtn == null) {
            this.deleteAppBtn = new JButton("Delete app");
            this.deleteAppBtn.setToolTipText("Delete the selected application, removing all its info in MeCoSim.");
            this.deleteAppBtn.addActionListener(this);
        }
        return this.deleteAppBtn;
    }

    private JButton getLoadConfigFileBtn() {
        if (this.loadConfigFileBtn == null) {
            this.loadConfigFileBtn = new JButton("Load config file");
            this.loadConfigFileBtn.setToolTipText("Load a new application from a spreadsheet file or reload (total o partially) an existing one.");
            this.loadConfigFileBtn.addActionListener(this);
        }
        return this.loadConfigFileBtn;
    }

    private JButton getRunAppBtn() {
        if (this.runAppBtn == null) {
            this.runAppBtn = new JButton("Run Application");
            this.runAppBtn.setToolTipText("Run the selected application");
            this.runAppBtn.addActionListener(this);
        }
        return this.runAppBtn;
    }

    private JScrollPane getAppListSPn() {
        if (this.appListSPn == null) {
            this.appListSPn = new JScrollPane();
            this.appListSPn.setAutoscrolls(true);
            this.appListSPn.setBackground(Color.lightGray);
            this.appListSPn.setViewportView(this.getAppListTbl(false));
        }
        return this.appListSPn;
    }

    public void reloadApps() {
        this.appListSPn.setViewportView(this.getAppListTbl(true));
    }

    private JTable getAppListTbl() {
        return this.getAppListTbl(false);
    }

    private JTable getAppListTbl(boolean reload) {
        if (this.appListTbl == null || reload) {
            this.appListTbl = new JTable();
            Object[][] data = this.getTblData();
            Object[] header = this.getTblTitles();
            DefaultTableModel dtModel = new DefaultTableModel(data, header){
                private static final long serialVersionUID = 1L;
                Class<?>[] types;
                {
                    this.types = new Class[]{Object.class, Object.class, Object.class, Object.class, Object.class, Object.class, Object.class, Object.class};
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    return this.types[columnIndex];
                }

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.appListTbl.setModel(dtModel);
        }
        this.setPreferredColumnWidths();
        return this.appListTbl;
    }

    private void setPreferredColumnWidths() {
        int[] preferredWidths = new int[]{60, 140, 260, 150, 120, 40, 50, 50};
        int i = 0;
        while (i < 7) {
            this.appListTbl.getColumnModel().getColumn(i).setPreferredWidth(preferredWidths[i]);
            ++i;
        }
    }

    private String[] getTblTitles() {
        return new String[]{"App Id", "App Name", "PLingua file path", "Data file path", "Current simulator", "Sims", "Cycles", "Steps"};
    }

    private Object[][] getTblData() {
        Object[][] data = DAOFacade.getApplicationsInfoForTbl();
        return data;
    }

    private JLabel getAppListLbl() {
        if (this.appListLbl == null) {
            this.appListLbl = new JLabel();
            this.appListLbl.setForeground(Color.blue);
            this.appListLbl.setText("List of available applications (run a pre-loaded application or load a new one)");
        }
        return this.appListLbl;
    }

    private static void installLnF() {
        try {
            String lnfClassname = PREFERRED_LOOK_AND_FEEL;
            if (lnfClassname == null) {
                lnfClassname = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            UIManager.setLookAndFeel(lnfClassname);
        }
        catch (Exception e) {
            System.err.println("Cannot install com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel on this platform:" + e.getMessage());
        }
    }

    public static void main(String[] args) {
        SelectApplicationFrm.installLnF();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectApplicationFrm frame = new SelectApplicationFrm();
                frame.setDefaultCloseOperation(3);
                frame.getContentPane().setPreferredSize(frame.getSize());
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        System.out.println("Performing action " + ev.getActionCommand() + "...");
        if (ev.getActionCommand().equals("Run Application")) {
            int selected = this.appListTbl.getSelectedRow();
            if (selected != -1) {
                String idS = this.appListTbl.getModel().getValueAt(selected, 0).toString();
                try {
                    int id = Integer.parseInt(idS);
                    DAOFacade.setCurrentApp(id);
                    DAOFacade.runApp(false);
                }
                catch (NumberFormatException e) {
                    System.out.println("Running current application");
                    DAOFacade.runApp(false);
                }
            } else {
                JOptionPane.showMessageDialog(this, "You must select an application to be run", "Selection error", 0);
            }
        } else if (ev.getActionCommand().equals("Load config file")) {
            File file = null;
            ConfigFileFilter filter = new ConfigFileFilter(3);
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(filter);
            chooser.setSelectedFile(file);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                File f = filter.completeExtension(chooser.getSelectedFile());
                this.loadFile(f);
            }
        } else if (ev.getActionCommand().equals("Delete app")) {
            int selected = this.appListTbl.getSelectedRow();
            if (selected != -1) {
                String idS = this.appListTbl.getModel().getValueAt(selected, 0).toString();
                try {
                    int id = Integer.parseInt(idS);
                    int i = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the information about the application with id " + id + "? ", "Delete application", 0);
                    if (i == 0) {
                        DAOFacade.deleteInfoForApp(id, true);
                        this.reloadApps();
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("Running current application");
                    DAOFacade.runApp(false);
                }
            } else {
                JOptionPane.showMessageDialog(this, "You must select an application to be deleted", "Selection error", 0);
            }
        } else if (ev.getActionCommand().equals("Export custom app")) {
            int selected = this.appListTbl.getSelectedRow();
            if (selected != -1) {
                String idS = this.appListTbl.getModel().getValueAt(selected, 0).toString();
                try {
                    int id = Integer.parseInt(idS);
                    this.exportCustomApp(id);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                JOptionPane.showMessageDialog(this, "You must select a custom application to be exported", "Selection error", 0);
            }
        } else if (ev.getActionCommand().equals("Exit")) {
            System.exit(0);
        }
    }

    private void exportCustomApp(int id) {
        ExportAppDlg dialog = new ExportAppDlg((Frame)this, id);
        dialog.loadInfo();
        this.reloadApps();
    }

    private void loadFile(File f) {
        LoadConfigFileDlg dialog = new LoadConfigFileDlg(f, this);
        dialog.loadInfo();
    }

    private void windowFocusWindowGainedFocus(WindowEvent event) {
        this.reloadApps();
    }
}

