/*
 * Decompiled with CFR 0.152.
 */
package ecoSim;

import ecoSim.DAOFacade;
import ecoSim.IMeCoSimConfig;
import ecoSim.ReflectionManager;
import ecoSim.factory.AbstractEcoSimFactory;
import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.gui.CustomEcoSimGUI;
import ecoSim.properties.PluginsPropertiesStore;
import ecoSim.properties.UnavailablePropertyException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.gcn.plinguacore.simulator.ISimulator;

public class PluginsManager {
    private ReflectionManager rm = ReflectionManager.getInstance();
    private static PluginsManager fcm;
    public static String pluginPrefix;
    public static String pluginParamPrefix;
    public static String pluginMethodPrefix;
    public static String pluginJarPrefix;
    public static String pluginNamePrefix;
    private PluginsPropertiesStore ppstore = PluginsPropertiesStore.getInstance();

    static {
        pluginPrefix = "plugin-";
        pluginParamPrefix = "pluginparam-";
        pluginMethodPrefix = "pluginmethod-";
        pluginJarPrefix = "pluginjar-";
        pluginNamePrefix = "pluginname-";
    }

    private PluginsManager() {
    }

    public static PluginsManager getInstance() {
        if (fcm == null) {
            fcm = new PluginsManager();
        }
        return fcm;
    }

    public void callPluginFunction(String pluginName, AbstractEcoSimGUI gui) {
        try {
            int configParameterName;
            String className = DAOFacade.getPluginProperty(String.valueOf(new String(pluginPrefix)) + pluginName);
            String method = DAOFacade.getPluginProperty(String.valueOf(new String(pluginMethodPrefix)) + pluginName);
            List<String> parameters = this.getPluginParameters(pluginName);
            ArrayList<Object> params = new ArrayList<Object>();
            String[] input = new String[parameters.size()];
            int i = 0;
            Iterator<String> iterator = parameters.iterator();
            while (iterator.hasNext()) {
                String value;
                input[i] = value = iterator.next();
                ++i;
            }
            params.add(input);
            TreeMap<Integer, Object> foundParameters = new TreeMap<Integer, Object>();
            int simParameterName = ReflectionManager.getInstance().receivesParameter(className, method, ISimulator.class);
            if (simParameterName != -1) {
                ISimulator sim = gui.getData().getSimulator();
                if (sim == null) {
                    gui.getData().readPLinguaFile(null, null, null, AbstractEcoSimFactory.getFactory(gui.getData().getFactoryName()).createParametersStrategy(), 0, null, gui.getData().getSimulationAlgorithm());
                    sim = gui.getData().getSimulator();
                }
                foundParameters.put(simParameterName, sim);
            }
            if ((configParameterName = ReflectionManager.getInstance().receivesParameter(className, method, IMeCoSimConfig.class)) != -1) {
                CustomEcoSimGUI cgui = (CustomEcoSimGUI)gui;
                foundParameters.put(configParameterName, cgui.getMecosimConfig());
            }
            for (Object o : foundParameters.values()) {
                params.add(o);
            }
            this.rm.invoke(className, method, params);
        }
        catch (UnavailablePropertyException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set<String> getPluginNames() throws UnavailablePropertyException {
        Set<String> propertyNames = this.ppstore.getPropNamesStartingWith(pluginPrefix);
        HashSet<String> pluginNames = new HashSet<String>();
        for (String s : propertyNames) {
            String className = DAOFacade.getPluginProperty(s);
            try {
                Class.forName(className);
                pluginNames.add(s.substring(pluginPrefix.length()));
            }
            catch (Exception ex) {
                System.out.println("Plugin class " + className + " not found. This plugin will not be added!");
            }
        }
        return pluginNames;
    }

    public List<String> getPluginParameters(String pluginName) throws UnavailablePropertyException {
        String pluginPrefix = String.valueOf(pluginParamPrefix) + pluginName + "-";
        List<String> paramValues = this.ppstore.getPropValuesForNamesStartingWith(pluginPrefix);
        return paramValues;
    }

    public List<String> getPluginJars(String pluginName) throws UnavailablePropertyException {
        String pluginPrefix = String.valueOf(pluginJarPrefix) + pluginName + "-";
        List<String> paramValues = this.ppstore.getPropValuesForNamesStartingWith(pluginPrefix);
        return paramValues;
    }

    public String getPluginShowingName(String pluginName) throws UnavailablePropertyException {
        String showingName = "";
        showingName = this.ppstore.getProperty(String.valueOf(pluginNamePrefix) + pluginName);
        return showingName;
    }

    public String getPluginMethod(String pluginName) throws UnavailablePropertyException {
        String showingName = "";
        showingName = this.ppstore.getProperty(String.valueOf(pluginMethodPrefix) + pluginName);
        return showingName;
    }

    public String getPluginClass(String pluginName) throws UnavailablePropertyException {
        String showingName = "";
        showingName = this.ppstore.getProperty(String.valueOf(pluginPrefix) + pluginName);
        return showingName;
    }
}

