/*
 * Decompiled with CFR 0.152.
 */
package ecoSim;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class ClasspathManager {
    private static final String ADD_URL_METHOD = "addURL";
    private static final Class[] METHOD_PARAMETER = new Class[]{URL.class};
    private final URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
    private final Method addMethod = URLClassLoader.class.getDeclaredMethod("addURL", METHOD_PARAMETER);

    public ClasspathManager() throws NoSuchMethodException {
        this.addMethod.setAccessible(true);
    }

    public URL[] getURLs() {
        return this.loader.getURLs();
    }

    public void addURL(URL url) {
        if (url != null) {
            try {
                this.addMethod.invoke((Object)this.loader, url);
            }
            catch (Exception ex) {
                System.err.println("Exception saving URL: " + ex.getLocalizedMessage());
            }
        }
    }

    public void addURLs(URL[] urls) {
        if (urls != null) {
            URL[] uRLArray = urls;
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                this.addURL(url);
                ++n2;
            }
        }
    }

    public void addFile(File archivo) throws MalformedURLException {
        if (archivo != null) {
            this.addURL(archivo.toURI().toURL());
        }
    }

    public void addFile(String nombreArchivo) throws MalformedURLException {
        this.addFile(new File(nombreArchivo));
    }
}

